/*
 * Decompiled with CFR 0.152.
 */
package boatcam.config;

import java.lang.reflect.Field;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import net.minecraft.class_2561;

@Config(name="boatcam")
public final class BoatCamConfig
implements ConfigData {
    @Comment(value="Whether the camera should be controlled by this mod or not.\nNOTE: This setting can be toggled using a key bind.")
    private boolean boatMode = true;
    @Comment(value="Frees camera movement when not moving in a boat.")
    private boolean stationaryLookAround = true;
    @Comment(value="1 - Smooth camera, might even lag behind.\n100 - Camera angle might change very abruptly.")
    @ConfigEntry.BoundedDiscrete(min=1L, max=100L)
    private int smoothness = 50;
    @Comment(value="Perspective when riding a boat in boat mode. Perspective wont change when this is set to none.")
    private Perspective perspective = Perspective.THIRD_PERSON;
    @Comment(value="Whether to fix the camera angle at a certain pitch.")
    private boolean fixedPitch = false;
    @Comment(value="Fixed vertical angle of the camera when fixedPitch is enabled.")
    @ConfigEntry.BoundedDiscrete(min=-90L, max=90L)
    private int pitch = 25;
    @Comment(value="Disables the turn limit in a boat.")
    private boolean turnLimitDisabled = true;

    private BoatCamConfig() {
    }

    public void validatePostLoad() {
        this.smoothness = Math.clamp((long)this.smoothness, 1, 100);
        this.pitch = Math.clamp((long)this.pitch, -90, 90);
        if (this.perspective == null) {
            this.perspective = Perspective.THIRD_PERSON;
        }
    }

    public static void saveConfig() {
        AutoConfig.getConfigHolder(BoatCamConfig.class).save();
    }

    public float getSmoothness() {
        return (float)this.smoothness / 100.0f;
    }

    public boolean isBoatMode() {
        return this.boatMode;
    }

    public boolean isStationaryLookAround() {
        return this.stationaryLookAround;
    }

    public boolean shouldFixPitch() {
        return this.fixedPitch;
    }

    public int getPitch() {
        return this.pitch;
    }

    public void toggleBoatMode() {
        this.boatMode = !this.boatMode;
        BoatCamConfig.saveConfig();
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public boolean isTurnLimitDisabled() {
        return this.turnLimitDisabled;
    }

    public static BoatCamConfig getConfig() {
        return (BoatCamConfig)AutoConfig.getConfigHolder(BoatCamConfig.class).get();
    }

    public static void registerPerspectiveConfiguration() {
        AutoConfig.getGuiRegistry(BoatCamConfig.class).registerPredicateTransformer((guis, s, f, c, d, g) -> BoatCamConfig.dropdownToEnumList(guis, f), field -> Perspective.class.isAssignableFrom(field.getType()));
    }

    private static List<AbstractConfigListEntry> dropdownToEnumList(List<AbstractConfigListEntry> guis, Field field) {
        return guis.stream().filter(DropdownBoxEntry.class::isInstance).map(DropdownBoxEntry.class::cast).map(dropdown -> ConfigEntryBuilder.create().startEnumSelector(dropdown.getFieldName(), Perspective.class, (Enum)((Perspective)((Object)((Object)dropdown.getValue())))).setDefaultValue((Enum)dropdown.getDefaultValue().orElse(null)).setSaveConsumer(p -> {
            try {
                field.set(BoatCamConfig.getConfig(), p);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }).setEnumNameProvider(perspective -> switch (((Perspective)((Object)((Object)perspective))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> class_2561.method_43471((String)"text.autoconfig.boatcam.option.perspective.firstPerson");
            case 2 -> class_2561.method_43471((String)"text.autoconfig.boatcam.option.perspective.thirdPerson");
            case 0 -> class_2561.method_43471((String)"text.autoconfig.boatcam.option.perspective.none");
        }).build()).map(AbstractConfigListEntry.class::cast).toList();
    }

    public static enum Perspective {
        NONE,
        FIRST_PERSON,
        THIRD_PERSON;

    }
}

