/*
 * Decompiled with CFR 0.152.
 */
package boatcam.config;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class BoatCamConfig {
    private static BoatCamConfig INSTANCE;
    private static final Path CONFIG_PATH;
    public boolean boatMode = true;
    public boolean stationaryLookAround = true;
    public int smoothness = 50;
    public Perspective perspective = Perspective.THIRD_PERSON;
    public boolean fixedPitch = false;
    public int pitch = 25;
    public boolean turnLimitDisabled = true;
    public boolean snapSidewaysView = false;

    private BoatCamConfig() {
    }

    public void validatePostLoad() {
        this.smoothness = Math.clamp((long)this.smoothness, 1, 100);
        this.pitch = Math.clamp((long)this.pitch, -90, 90);
        if (this.perspective == null) {
            this.perspective = Perspective.THIRD_PERSON;
        }
    }

    public float getSmoothness() {
        return (float)this.smoothness / 100.0f;
    }

    public void toggleBoatMode() {
        this.boatMode = !this.boatMode;
        this.save();
    }

    public Perspective getPerspective() {
        return this.perspective;
    }

    public boolean isTurnLimitDisabled() {
        return this.turnLimitDisabled;
    }

    public void save() {
        try {
            if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
                Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            }
            Gson gson = new Gson();
            Files.writeString(CONFIG_PATH, (CharSequence)gson.toJson((Object)this), new OpenOption[0]);
        }
        catch (Exception e) {
            System.err.println("Could not write config: " + e.getMessage());
        }
    }

    public static void load() throws IOException {
        if (Files.notExists(CONFIG_PATH, new LinkOption[0])) {
            INSTANCE = new BoatCamConfig();
            return;
        }
        Gson gson = new Gson();
        INSTANCE = (BoatCamConfig)gson.fromJson(Files.readString(CONFIG_PATH), BoatCamConfig.class);
        INSTANCE.validatePostLoad();
    }

    public static BoatCamConfig getConfig() {
        return INSTANCE;
    }

    static {
        CONFIG_PATH = Path.of("config", "boatcam.json5");
    }

    public static enum Perspective {
        NONE,
        FIRST_PERSON,
        THIRD_PERSON;

    }
}

