/*
 * Decompiled with CFR 0.152.
 */
package com.lyki;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1493;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PetSystem
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PetSystem");
    private Object selectedPet;
    private JsonObject config;

    public void onInitialize() {
        this.loadConfig();
        LOGGER.info("PetSystem by lykiaofficial");
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, registrationEnvironment) -> this.registerPetCommand((CommandDispatcher<class_2168>)dispatcher));
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (hand == class_1268.field_5808 && player.method_5715() && (entity instanceof class_1451 || entity instanceof class_1493 || entity instanceof class_1453)) {
                class_1451 pet;
                Object object = entity instanceof class_1451 ? (class_1451)entity : (pet = entity instanceof class_1493 ? (class_1493)entity : (class_1453)entity);
                if (this.selectedPet != pet && (entity instanceof class_1451 && pet.method_6171((class_1309)player) || entity instanceof class_1493 && ((class_1493)pet).method_6181() && ((class_1493)pet).method_35057().method_5667().equals(player.method_5667()) || entity instanceof class_1453 && ((class_1453)pet).method_6181() && ((class_1453)pet).method_35057().method_5667().equals(player.method_5667()))) {
                    this.selectedPet = pet;
                    String petName = "";
                    if (pet instanceof class_1451) {
                        petName = pet.method_5477().getString();
                    } else if (pet instanceof class_1493) {
                        petName = ((class_1493)pet).method_5477().getString();
                    } else if (pet instanceof class_1453) {
                        petName = ((class_1453)pet).method_5477().getString();
                    }
                    player.method_7353(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("pet_selected", "%petnameortype%", petName))), false);
                    return class_1269.field_5812;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    private class_5250 formatTextWithColor(String text) {
        String[] parts;
        class_5250 mutableText = (class_5250)class_2561.method_30163((String)"");
        for (String part : parts = text.split("(?=#[0-9a-fA-F]{6})")) {
            if (part.startsWith("#")) {
                String hexColor = part.substring(0, 7);
                String content = part.substring(7);
                mutableText = mutableText.method_10852((class_2561)class_2561.method_43470((String)content).method_27694(style -> style.method_27703(class_5251.method_27717((int)Integer.parseInt(hexColor.substring(1), 16)))));
                continue;
            }
            mutableText = mutableText.method_10852((class_2561)class_2561.method_43470((String)part));
        }
        return mutableText;
    }

    private void loadConfig() {
        Path configDir = Paths.get("config/PetSystem", new String[0]);
        Path configFile = configDir.resolve("petsystem_config.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/petsystem_config.json")), configFile, new CopyOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Gson gson = new Gson();
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            this.config = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getConfigMessage(String key, String ... replacements) {
        String message = this.config.has(key) ? this.config.get(key).getAsString() : key;
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        return message;
    }

    private void registerPetCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pet").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(2))).executes(this::executeReloadConfig)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"petgive").then(class_2170.method_9244((String)"playername", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"playername");
            return this.executeGive((CommandContext<class_2168>)context, player);
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"petfree").executes(this::executeRelease));
    }

    private int executeGive(CommandContext<class_2168> context, class_3222 newOwner) {
        class_2168 sender = (class_2168)context.getSource();
        class_3222 currentOwner = sender.method_44023();
        if (this.selectedPet != null && (this.selectedPet instanceof class_1451 && ((class_1451)this.selectedPet).method_6171((class_1309)currentOwner) || this.selectedPet instanceof class_1493 && ((class_1493)this.selectedPet).method_6181() && Objects.equals(((class_1493)this.selectedPet).method_35057().method_5667(), Objects.requireNonNull(currentOwner).method_5667()) || this.selectedPet instanceof class_1453 && ((class_1453)this.selectedPet).method_6181() && Objects.equals(((class_1453)this.selectedPet).method_35057().method_5667(), Objects.requireNonNull(currentOwner).method_5667())) && !newOwner.method_5667().equals(Objects.requireNonNull(currentOwner).method_5667())) {
            if (this.selectedPet instanceof class_1451) {
                class_1451 cat = (class_1451)this.selectedPet;
                cat.method_6174((class_1309)newOwner);
                sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("gave_your_pet", "%receivername%", newOwner.method_5477().getString(), "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                newOwner.method_7353(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("been_a_given_pet_to_you", "%givername%", currentOwner.method_5477().getString(), "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                this.selectedPet = null;
            } else if (this.selectedPet instanceof class_1493) {
                class_1493 wolf = (class_1493)this.selectedPet;
                wolf.method_6174((class_1309)newOwner);
                sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("gave_your_pet", "%receivername%", newOwner.method_5477().getString(), "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                newOwner.method_7353(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("been_a_given_pet_to_you", "%givername%", currentOwner.method_5477().getString(), "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                this.selectedPet = null;
            } else if (this.selectedPet instanceof class_1453) {
                class_1453 parrot = (class_1453)this.selectedPet;
                if (parrot.method_24345()) {
                    parrot.method_6174((class_1309)newOwner);
                    sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("gave_your_pet", "%receivername%", newOwner.method_5477().getString(), "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                    newOwner.method_7353(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("been_a_given_pet_to_you", "%givername%", currentOwner.method_5477().getString(), "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                } else {
                    sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("parrot_must_be_sitting", new String[0]))), false);
                }
                this.selectedPet = null;
            }
            return 0;
        }
        if (this.selectedPet == null) {
            sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("no_pet_selected", new String[0]))), false);
        } else if (((class_1321)this.selectedPet).method_6171((class_1309)currentOwner)) {
            sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("cant_give_pet_to_yourself", new String[0]))), false);
        }
        return 0;
    }

    private int executeReloadConfig(CommandContext<class_2168> context) {
        class_2168 sender = (class_2168)context.getSource();
        this.loadConfig();
        sender.method_45068(class_2561.method_54155((Message)this.formatTextWithColor("#FF0000PetSystem #FFFFFFConfig successfully reloaded.")));
        return 1;
    }

    private int executeRelease(CommandContext<class_2168> context) {
        class_2168 sender = (class_2168)context.getSource();
        if (this.selectedPet != null) {
            if (this.selectedPet instanceof class_1451) {
                class_1451 cat = (class_1451)this.selectedPet;
                cat.method_6174((class_1309)null);
                cat.method_24346(false);
                cat.method_5665(null);
                cat.method_6173(false, true);
                cat.method_5971();
                sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("pet_released", "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                this.selectedPet = null;
            } else if (this.selectedPet instanceof class_1493) {
                class_1493 wolf = (class_1493)this.selectedPet;
                wolf.method_6174((class_1309)null);
                wolf.method_24346(false);
                wolf.method_5665(null);
                wolf.method_6173(false, true);
                wolf.method_5971();
                sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("pet_released", "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                this.selectedPet = null;
            } else if (this.selectedPet instanceof class_1453) {
                class_1453 parrot = (class_1453)this.selectedPet;
                if (parrot.method_24345()) {
                    parrot.method_6179(false);
                    parrot.method_6174((class_1309)null);
                    parrot.method_24346(false);
                    parrot.method_5665(null);
                    parrot.method_6173(false, true);
                    parrot.method_5971();
                    sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("pet_released", "%petnameortype%", ((class_1321)this.selectedPet).method_5477().getString()))), false);
                    this.selectedPet = null;
                } else {
                    sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("parrot_must_be_sitting", new String[0]))), false);
                    this.selectedPet = null;
                }
            }
            return 1;
        }
        sender.method_9226(() -> class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("no_pet_selected", new String[0]))), false);
        return 0;
    }
}

