package com.github.thedeathlycow.scorchful.block;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

@FunctionalInterface
public interface NetherLilyBehaviour {

    class_1269 interact(
            class_2680 state,
            class_1937 world,
            class_2338 pos,
            class_1657 player,
            class_1268 hand,
            class_1799 stack
    );

    Map<String, NetherLilyBehaviourMap> BEHAVIOUR_MAPS = new Object2ObjectArrayMap<>();

    Codec<NetherLilyBehaviourMap> CODEC = Codec.stringResolver(NetherLilyBehaviourMap::name, BEHAVIOUR_MAPS::get);

    static NetherLilyBehaviourMap createMap(String name) {
        var map = new Object2ObjectOpenHashMap<class_1792, NetherLilyBehaviour>();
        map.defaultReturnValue((state, world, pos, player, hand, stack) -> class_1269.field_52423);

        var behaviourMap = new NetherLilyBehaviourMap(name, map);
        BEHAVIOUR_MAPS.put(name, behaviourMap);
        return behaviourMap;
    }

    record NetherLilyBehaviourMap(
            String name,
            Map<class_1792, NetherLilyBehaviour> map
    ) {

    }

}
