package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.server.Sandstorms;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3611;
import net.minecraft.class_5620;
import net.minecraft.class_5712;

public class SandCauldronBlock extends class_2275 {

    public static final MapCodec<SandCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            Sandstorms.SandstormType.CODEC
                                    .fieldOf("sandstorm_type")
                                    .forGetter(block -> block.sandstormType),
                            class_5620.field_46590
                                    .fieldOf("interactions")
                                    .forGetter(block -> block.field_27084),
                            method_54096()
                    )
                    .apply(instance, SandCauldronBlock::new)
    );

    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 3;
    public static final class_2758 LEVEL = class_2741.field_12513;
    private static final int BASE_FLUID_HEIGHT = 6;
    private static final double FLUID_HEIGHT_PER_LEVEL = 3.0;

    private static final float FILL_WITH_SAND_CHANCE = 0.1f;

    private final Sandstorms.SandstormType sandstormType;

    /**
     * Constructs a leveled cauldron block.
     *
     * @param settings
     * @param sandstormType     The type of sandstorm this will fill in
     * @param behaviorMap       other behaviours for this cauldron
     */
    public SandCauldronBlock(
            Sandstorms.SandstormType sandstormType,
            class_5620.class_8821 behaviorMap,
            class_2251 settings
    ) {
        super(settings, behaviorMap);
        this.sandstormType = sandstormType;
        this.method_9590(
                this.method_9564()
                        .method_11657(LEVEL, 3)
        );
    }

    public static boolean canFillWithSand(class_1937 world, Sandstorms.SandstormType sandstormType) {
        return switch (sandstormType) {
            case RED, REGULAR -> world.method_8409().method_43057() < FILL_WITH_SAND_CHANCE;
            default -> false;
        };
    }

    @Override
    public MapCodec<SandCauldronBlock> method_53969() {
        return field_46280;
    }

    @Override
    @SuppressWarnings("deprecation")
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return state.method_11654(LEVEL);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(LEVEL);
    }

    @Override
    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        Sandstorms.SandstormType type = Sandstorms.getCurrentSandStorm(world, pos.method_10084());

        if (this.sandstormType != type || !canFillWithSand(world, type) || state.method_11654(LEVEL) == MAX_LEVEL) {
            return;
        }

        class_2680 filled = state.method_28493(LEVEL);
        world.method_8501(pos, filled);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(filled));
    }

    @Override
    public class_1792 method_8389() {
        return class_1802.field_8638;
    }

    @Override
    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
        // stub: don't extinguish entities on fire
    }

    @Override
    protected boolean method_32765(class_3611 fluid) {
        return false;
    }

    @Override
    public boolean method_32766(class_2680 state) {
        return state.method_11654(LEVEL) == MAX_LEVEL;
    }

    @Override
    protected double method_31615(class_2680 state) {
        return (BASE_FLUID_HEIGHT + state.method_11654(LEVEL) * FLUID_HEIGHT_PER_LEVEL) / 16.0;
    }
}
