package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2398;

public final class SoakedEffects {

    private static final float SLOW_DRIP_MULTIPLIER = 2.0f;

    /**
     * Renders water particles on players that are wet. The chance of a drip spawning is the same
     * as the player's wetness scale.
     * This is done on the client side to avoid sending unnecessary packets and save bandwidth.
     */
    public static void tickDripParticles(class_1657 player, class_1937 world, boolean submergedInWater) {
        if (world.method_8608()) { // only show particles on client to save bandwidth

            // config to disable
            if (!ScorchfulConfig.getClientConfig().enableWetDripParticles()) {
                return;
            }

            // spectators should not drip
            if (player.method_7325()) {
                return;
            }

            // only spawn particles when out of water
            if (submergedInWater) {
                return;
            }

            // Ensure that only players with non-zero wetness have particles
            // (I mostly just don't trust floats lol)
            if (!player.thermoo$isWet()) {
                return;
            }

            ThreadLocalRandom random = ThreadLocalRandom.current();

            // Spawn drip with probability proportional to wetness scale
            if (SLOW_DRIP_MULTIPLIER * random.nextFloat() < player.thermoo$getSoakedScale()) {

                class_238 boundingBox = player.method_5829();

                // pick random pos in player bounding box
                double x = boundingBox.method_1001(class_2350.class_2351.field_11048) + random.nextDouble(boundingBox.method_17939());
                double y = boundingBox.method_1001(class_2350.class_2351.field_11052) + random.nextDouble(boundingBox.method_17940());
                double z = boundingBox.method_1001(class_2350.class_2351.field_11051) + random.nextDouble(boundingBox.method_17941());

                world.method_8406(
                        class_2398.field_28079,
                        x, y, z,
                        0, 0, 0
                );
            }
        }
    }

    private SoakedEffects() {

    }
}
