package com.github.thedeathlycow.scorchful.entity.ai;

import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_5532;

public class FearTargetGoal extends class_1352 {

    private static final double FAST_FLEE_RANGE = 7.0;

    private final class_1314 mob;
    private final double slowSpeed;
    private final double fastSpeed;
    @Nullable
    private class_11 fleePath;

    public FearTargetGoal(class_1314 mob) {
        this(mob, 1.0, 1.2);
    }

    public FearTargetGoal(class_1314 mob, double slowSpeed, double fastSpeed) {
        this.mob = mob;
        this.slowSpeed = slowSpeed;
        this.fastSpeed = fastSpeed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    @Override
    public boolean method_6264() {
        if (this.mob.method_5968() == null || !this.mob.method_6059(SStatusEffects.FEAR)) {
            return false;
        }

        this.fleePath = this.findFleePath(this.mob.method_5968());
        return this.fleePath != null;
    }

    @Override
    public void method_6269() {
        this.mob.method_5942().method_6334(this.fleePath, 1.0);
    }

    @Override
    public boolean method_6266() {
        return !this.mob.method_5942().method_6357();
    }

    private class_11 findFleePath(class_1309 target) {
        class_243 targetPos = class_5532.method_31511(this.mob, 16, 7, target.method_73189());
        return targetPos != null
                ? this.mob.method_5942().method_6352(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 0)
                : null;
    }

    @Override
    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target != null && this.mob.method_5858(target) < FAST_FLEE_RANGE * FAST_FLEE_RANGE) {
            this.mob.method_5942().method_6344(this.fastSpeed);
        } else {
            this.mob.method_5942().method_6344(this.slowSpeed);
        }
    }
}
