package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import java.util.List;
import java.util.function.Consumer;

public final class CoolingItemTooltip implements ItemTooltipCallback {
    private static final class_2561 COOLING_TOOLTIP = class_2561.method_43471("item.scorchful.tooltip.cooling")
            .method_10862(class_2583.field_24360.method_10977(class_124.field_1075));

    @Override
    public void getTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 tooltipType, List<class_2561> tooltip) {
        Consumer<class_2561> builder = text -> addTooltipBeforeAdvanced(stack, tooltipType, tooltip, text);

        if (stack.method_31573(SItemTags.IS_COOLING_FOOD)) {
            builder.accept(COOLING_TOOLTIP);
        }
    }

    private static void addTooltipBeforeAdvanced(
            class_1799 stack,
            class_1836 tooltipType,
            List<class_2561> lines,
            class_2561 tooltipText
    ) {
        if (!tooltipType.method_8035()) {
            lines.add(tooltipText);
            return;
        }

        class_2960 identifier = class_7923.field_41178.method_10221(stack.method_7909());
        class_2561 idAsText = class_2561.method_43470(identifier.toString());

        for (int i = lines.size() - 1; i >= 0; i--) {
            if (lines.get(i).method_44745(idAsText)) {
                lines.add(i, tooltipText);
                return;
            }
        }
    }
}
