package com.github.thedeathlycow.scorchful.item.component;

import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public record DrinkContainerComponent(int numDrinks, int maxDrinks) implements class_9299 {
    public static final class_2583 TOOLTIP_STYLE = class_2583.field_24360
            .method_10977(class_124.field_1075);

    public static final DrinkContainerComponent DEFAULT = new DrinkContainerComponent(0, 16);

    private static final Codec<DrinkContainerComponent> VALUE_CODEC = RecordCodecBuilder.<DrinkContainerComponent>create(
            instance -> instance.group(
                    Codec.INT
                            .fieldOf("num_drinks")
                            .forGetter(DrinkContainerComponent::numDrinks),
                    class_5699.field_33442
                            .optionalFieldOf("max_drinks", DEFAULT.maxDrinks)
                            .forGetter(DrinkContainerComponent::maxDrinks)
            ).apply(instance, DrinkContainerComponent::new)
    ).validate(component -> {
        if (component.numDrinks < 0 || component.numDrinks > component.maxDrinks) {
            return DataResult.error(() -> "Num drinks not in range [0, " + component.maxDrinks + "]: " + component.numDrinks);
        } else {
            return DataResult.success(component);
        }
    });

    public static final Codec<DrinkContainerComponent> CODEC = Codec.either(class_5699.method_48766(0, DEFAULT.maxDrinks), VALUE_CODEC)
            .xmap(
                    either -> either.map(i -> new DrinkContainerComponent(i, DEFAULT.maxDrinks), container -> container),
                    Either::right
            );

    public static final class_9139<class_9129, DrinkContainerComponent> PACKET_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            DrinkContainerComponent::numDrinks,
            class_9135.field_48550,
            DrinkContainerComponent::maxDrinks,
            DrinkContainerComponent::new
    );

    public static DrinkContainerComponent addDrinks(class_1799 stack, int value) {
        return stack.method_57368(
                SDataComponentTypes.DRINK_CONTAINER,
                DEFAULT,
                current -> current.addDrinks(value)
        );
    }

    public static DrinkContainerComponent fillCompletely(class_1799 stack) {
        return stack.method_57368(
                SDataComponentTypes.DRINK_CONTAINER,
                DEFAULT,
                current -> current.addDrinks(current.maxDrinks)
        );
    }

    public DrinkContainerComponent addDrinks(int value) {
        return new DrinkContainerComponent(
                class_3532.method_15340(this.numDrinks + value, 0, this.maxDrinks),
                this.maxDrinks
        );
    }

    public float getCurrentFill() {
        return (float) this.numDrinks / this.maxDrinks;
    }

    public boolean hasDrink() {
        return this.numDrinks > 0;
    }

    public boolean isEmpty() {
        return !this.hasDrink();
    }

    public boolean isFull() {
        return this.numDrinks >= this.maxDrinks;
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
        class_5250 text = this.hasDrink()
                ? class_2561.method_43469("item.scorchful.water_skin.tooltip.count", this.numDrinks(), this.maxDrinks())
                : class_2561.method_43471("item.scorchful.water_skin.tooltip.empty");
        text.method_10862(TOOLTIP_STYLE);
        tooltip.accept(text);
    }
}