package com.github.thedeathlycow.scorchful.item.component;

import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import com.github.thedeathlycow.scorchful.components.PlayerWaterComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.ThirstConfig;
import com.github.thedeathlycow.scorchful.item.WaterSkinItem;
import com.github.thedeathlycow.scorchful.mixin.accessor.RegistryEntryReferenceAccessor;
import com.github.thedeathlycow.scorchful.registry.SDataComponentTypes;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.class_10124;
import net.minecraft.class_10127;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public enum DrinkLevelComponent implements class_3542, class_10127, class_9299 {
    PARCHING(
            "parching",
            SItemTags.IS_PARCHING,
            class_2561.method_43471("item.scorchful.tooltip.parching").method_10862(WaterSkinItem.PARCHING_STYLE),
            ThirstConfig::getWaterFromParchingFood
    ),
    REFRESHING(
            "refreshing",
            SItemTags.IS_REFRESHING,
            class_2561.method_43471("item.scorchful.tooltip.refreshing").method_10862(WaterSkinItem.TOOLTIP_STYLE),
            ThirstConfig::getWaterFromRefreshingFood
    ),
    SUSTAINING(
            "sustaining",
            SItemTags.IS_SUSTAINING,
            class_2561.method_43471("item.scorchful.tooltip.sustaining").method_10862(WaterSkinItem.TOOLTIP_STYLE),
            ThirstConfig::getWaterFromSustainingFood
    ),
    HYDRATING(
            "hydrating",
            SItemTags.IS_HYDRATING,
            class_2561.method_43471("item.scorchful.tooltip.hydrating").method_10862(WaterSkinItem.TOOLTIP_STYLE),
            ThirstConfig::getWaterFromHydratingFood
    );

    public static final Codec<DrinkLevelComponent> CODEC = class_3542.method_28140(DrinkLevelComponent::values);
    public static final IntFunction<DrinkLevelComponent> ID_TO_VALUE = class_7995.method_47914(
            DrinkLevelComponent::ordinal, values(), class_7995.class_7996.field_41664
    );
    public static final class_9139<ByteBuf, DrinkLevelComponent> PACKET_CODEC = class_9135.method_56375(
            ID_TO_VALUE, DrinkLevelComponent::ordinal
    );

    private final String name;

    private final class_6862<class_1792> tag;

    private final class_2561 tooltipText;

    private final ToIntFunction<ThirstConfig> waterProvider;

    DrinkLevelComponent(String name, class_6862<class_1792> tag, class_2561 tooltipText, ToIntFunction<ThirstConfig> waterProvider) {
        this.name = name;
        this.tag = tag;
        this.tooltipText = tooltipText;
        this.waterProvider = waterProvider;
    }

    public static void applyToNewStack(class_1799 stack) {
        if (stack.method_57826(SDataComponentTypes.DRINK_LEVEL)) {
            return;
        }

        if (((RegistryEntryReferenceAccessor) stack.method_7909().method_40131()).scorchful$tags() == null) {
            return;
        }

        DrinkLevelComponent level = byTag(stack);
        if (level != null) {
            stack.method_57379(SDataComponentTypes.DRINK_LEVEL, level);
        }
    }

    public static void spawnWaterParticles(class_1937 world, class_1309 entity, int count) {
        class_5819 random = entity.method_59922();

        for (int i = 0; i < count; i++) {

            var velocity = new class_243((random.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 1, 0);
            velocity = velocity.method_1037(-entity.method_36455() * (class_3532.field_29844 / 180f));
            velocity = velocity.method_1024(-entity.method_36454() * (class_3532.field_29844 / 180f));

            double y = -random.method_43057() * 0.6 - 0.3;
            var postion = new class_243((random.method_43057() - 0.5) * 0.3, y, 0.6);
            postion = postion.method_1037(-entity.method_36455() * (class_3532.field_29844 / 180f));
            postion = postion.method_1024(-entity.method_36454() * (class_3532.field_29844 / 180f));
            postion = postion.method_1031(entity.method_23317(), entity.method_23320(), entity.method_23321());

            world.method_8406(
                    class_2398.field_11202,
                    postion.field_1352, postion.field_1351, postion.field_1350,
                    velocity.field_1352, velocity.field_1351 + 1, velocity.field_1350
            );
        }
    }

    @Nullable
    private static DrinkLevelComponent byTag(class_1799 stack) {
        for (DrinkLevelComponent level : values()) {
            if (stack.method_31573(level.tag)) {
                return level;
            }
        }

        return null;
    }

    public int getDrinkingWater(ThirstConfig config) {
        return this.waterProvider.applyAsInt(config);
    }

    public class_2561 getTooltipText() {
        return tooltipText;
    }

    @Override
    public String method_15434() {
        return this.name;
    }

    @Override
    public void method_62831(class_1937 world, class_1309 user, class_1799 stack, class_10124 consumable) {
        if (ServerThirstPlugin.isCustomPluginLoaded()) {
            return;
        }

        PlayerWaterComponent waterComponent = ScorchfulComponents.PLAYER_WATER.getNullable(user);
        if (waterComponent != null) {
            int water = this.getDrinkingWater(ScorchfulConfig.getThirstConfig());
            waterComponent.drink(water);

            if (waterComponent.getWaterDrunk() >= PlayerWaterComponent.MAX_WATER * 0.9) {
                user.method_5783(SSoundEvents.ENTITY_GULP, 1f, 1f);
            }
        }
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
        tooltip.accept(this.tooltipText);
    }
}
