package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.event.ScorchfulItemEvents;
import com.github.thedeathlycow.scorchful.item.FireChargeThrower;
import com.github.thedeathlycow.scorchful.item.SunHatItem;
import com.github.thedeathlycow.scorchful.item.TurtleArmorEffects;
import com.github.thedeathlycow.scorchful.item.WaterSkinItem;
import com.github.thedeathlycow.scorchful.item.component.DrinkContainerComponent;
import com.github.thedeathlycow.scorchful.item.component.DrinkLevelComponent;
import com.github.thedeathlycow.scorchful.item.component.HeatResistanceComponent;
import com.github.thedeathlycow.scorchful.item.component.HeatResistanceModifier;
import com.github.thedeathlycow.scorchful.item.enchantment.EnchantmentModifiers;
import com.github.thedeathlycow.scorchful.item.loot.TurtleScuteLootTableModifier;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_10128;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8051;
import net.minecraft.class_9334;
import java.util.function.Function;

public final class SItems {
    public static final class_1792 WATER_SKIN = register(
            "water_skin",
            settings -> new WaterSkinItem(
                    settings
                            .method_7889(1)
                            .method_57349(class_9334.field_53964, class_10128.field_53780)
                            .method_57349(SDataComponentTypes.DRINK_CONTAINER, DrinkContainerComponent.DEFAULT)
                            .method_57349(SDataComponentTypes.DRINK_LEVEL, DrinkLevelComponent.HYDRATING)
            )
    );

    public static final class_1792 SUN_HAT = register("sun_hat", SunHatItem::createItem);

    public static final class_1792 CACTUS_JUICE = register(
            "cactus_juice",
            settings -> new class_1792(
                    settings.method_7889(16)
                            .method_7896(class_1802.field_8469)
                            .method_62834(class_1802.field_8469)
                            .method_57349(class_9334.field_53964, class_10128.field_53780)
                            .method_57349(SDataComponentTypes.DRINK_LEVEL, DrinkLevelComponent.HYDRATING)
            )
    );

    public static final class_1792 CRIMSON_LILY = register("crimson_lily", SBlocks.CRIMSON_LILY);

    public static final class_1792 WARPED_LILY = register("warped_lily", SBlocks.WARPED_LILY);

    public static final class_1792 ROOTED_NETHERRACK = register("rooted_netherrack", SBlocks.ROOTED_NETHERRACK);

    public static final class_1792 ROOTED_CRIMSON_NYLIUM = register("rooted_crimson_nylium", SBlocks.ROOTED_CRIMSON_NYLIUM);

    public static final class_1792 ROOTED_WARPED_NYLIUM = register("rooted_warped_nylium", SBlocks.ROOTED_WARPED_NYLIUM);

    public static final class_1792 SAND_PILE = register("sand_pile", SBlocks.SAND_PILE);

    public static final class_1792 RED_SAND_PILE = register("red_sand_pile", SBlocks.RED_SAND_PILE);

    public static final class_1792 TURTLE_CHESTPLATE = register(
            "turtle_chestplate",
            settings -> new class_1792(
                    settings
                            .method_66332(SArmorMaterials.TURTLE, class_8051.field_41935)
                            .method_7895(class_8051.field_41935.method_56690(25))
                            .method_57349(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static final class_1792 TURTLE_LEGGINGS = register(
            "turtle_leggings",
            settings -> new class_1792(
                    settings
                            .method_66332(SArmorMaterials.TURTLE, class_8051.field_41936)
                            .method_7895(class_8051.field_41936.method_56690(25))
                            .method_57349(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static final class_1792 TURTLE_BOOTS = register(
            "turtle_boots",
            settings -> new class_1792(
                    settings
                            .method_66332(SArmorMaterials.TURTLE, class_8051.field_41937)
                            .method_7895(class_8051.field_41937.method_56690(25))
                            .method_57349(SDataComponentTypes.HEAT_RESISTANCE, HeatResistanceComponent.VERY_PROTECTIVE)
            )
    );

    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful items");
        UseItemCallback.EVENT.register(new FireChargeThrower());
        ScorchfulItemEvents.GET_DEFAULT_STACK.register(DrinkLevelComponent::applyToNewStack);
        ScorchfulItemEvents.CONSUME_ITEM.register((stack, player) -> {
            if (stack.method_31573(SItemTags.IS_COOLING_FOOD)) {
                player.thermoo$addTemperature(
                        ScorchfulConfig.getHeatingConfig().getTemperatureFromCoolingFood(),
                        HeatingModes.ACTIVE
                );
            }
        });
        HeatResistanceModifier.initialize();
        LootTableEvents.MODIFY.register(new TurtleScuteLootTableModifier());
        EnchantmentModifiers.initialize();
        TurtleArmorEffects.initialize();
    }

    private static class_1792 register(String id, class_2248 block) {
        return register(id, settings -> new class_1747(block, settings.method_63685()));
    }

    private static class_1792 register(String id, Function<class_1792.class_1793, class_1792> itemFactory) {
        return register(id, itemFactory, new class_1792.class_1793());
    }

    private static class_1792 register(String id, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
        class_5321<class_1792> key = class_5321.method_29179(class_7924.field_41197, Scorchful.id(id));
        class_1792 item = itemFactory.apply(settings.method_63686(key));
        return class_2378.method_39197(class_7923.field_41178, key, item);
    }

    private SItems() {

    }
}
