package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.mixin.accessor.PointOfInterestTypeAccessor;
import com.github.thedeathlycow.scorchful.mixin.accessor.PointOfInterestTypesAccessor;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2680;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import net.minecraft.class_7477;
import net.minecraft.class_7923;

public final class SPointsOfInterest {
    public static final Set<class_2680> SAND_CAULDRONS = Stream.of(
                    SBlocks.SAND_CAULDRON,
                    SBlocks.RED_SAND_CAULDRON
            )
            .flatMap(block -> block.method_9595().method_11662().stream())
            .collect(ImmutableSet.toImmutableSet());

    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful POIs");
        class_6880<class_4158> leatherWorkerPOI = class_7923.field_41128
                .method_46747(class_7477.field_39285);

        ((PointOfInterestTypeAccessor) (Object) leatherWorkerPOI.comp_349()).scorchful$setBlockStates(
                ImmutableSet.<class_2680>builder()
                        .addAll(leatherWorkerPOI.comp_349().comp_815())
                        .addAll(SPointsOfInterest.SAND_CAULDRONS)
                        .build()
        );
        registerStates(leatherWorkerPOI, SPointsOfInterest.SAND_CAULDRONS);
    }

    private static void registerStates(class_6880<class_4158> poiTypeEntry, Set<class_2680> states) {
        states.forEach(state -> {
            class_6880<class_4158> existing = PointOfInterestTypesAccessor.scorchful$getStatesToType()
                    .put(state, poiTypeEntry);
            if (existing != null) {
                throw class_156.method_22320(new IllegalStateException(String.format(Locale.ROOT, "%s is defined in more than one PoI type", state)));
            }
        });
    }

    private SPointsOfInterest() {

    }

}
