package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.registry.tag.SBiomeTags;
import com.mojang.serialization.Codec;
import com.thedeathlycow.immersive.storms.util.WeatherEffectType;
import com.thedeathlycow.immersive.storms.util.WeatherEffects;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3542;
import net.minecraft.class_6880;

public class Sandstorms {

    public enum SandstormType implements class_3542 {
        NONE("no_sandstorm"),
        REGULAR("regular_sandstorm"),
        RED("red_sandstorm");

        public static final Codec<SandstormType> CODEC = class_3542.method_28140(SandstormType::values);

        private final String id;

        SandstormType(String id) {
            this.id = id;
        }

        @Override
        public String method_15434() {
            return this.id;
        }
    }

    /**
     * Determines if the position in the world has an active sand storm.
     *
     * @return Returns {@link SandstormType#NONE} if it is not sand storming at the position in the world.
     * Returns {@link SandstormType#REGULAR} if it is raining in a desert and {@link SandstormType#RED} if it is raining
     * in a badlands.
     */
    public static SandstormType getCurrentSandStorm(class_1937 world, class_2338 pos, boolean includeSurface) {
        WeatherEffectType type = WeatherEffects.getCurrentType(world, pos, includeSurface);

        if (type == WeatherEffectType.SANDSTORM) {
            class_6880<class_1959> biome = world.method_22385().method_27344(pos);
            if (hasRedSandStorms(biome)) {
                return SandstormType.RED;
            } else if (hasRegularSandStorms(biome)) {
                return SandstormType.REGULAR;
            }
        }

        return SandstormType.NONE;
    }

    public static SandstormType getCurrentSandStorm(class_1937 world, class_2338 pos) {
        return getCurrentSandStorm(world, pos, true);
    }

    public static boolean hasRegularSandStorms(class_6880<class_1959> biome) {
        return !biome.comp_349().method_48163() && biome.method_40220(SBiomeTags.HAS_REGULAR_SAND_STORMS);
    }

    public static boolean hasRedSandStorms(class_6880<class_1959> biome) {
        return !biome.comp_349().method_48163() && biome.method_40220(SBiomeTags.HAS_RED_SAND_STORMS);
    }

    private Sandstorms() {

    }
}
