package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.HeatingConfig;
import com.github.thedeathlycow.thermoo.api.environment.component.EnvironmentComponentTypes;
import com.github.thedeathlycow.thermoo.api.environment.component.TemperatureRecordComponent;
import com.github.thedeathlycow.thermoo.api.environment.event.ServerPlayerEnvironmentTickEvents;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.util.TemperatureRecord;
import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class ServerPlayerEnvironmentTickListeners {
    public static void initialize() {
        ServerPlayerEnvironmentTickEvents.GET_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::getTemperatureChange);
        ServerPlayerEnvironmentTickEvents.ALLOW_TEMPERATURE_CHANGE.register(ServerPlayerEnvironmentTickListeners::allowTemperatureChange);
    }

    private static int getTemperatureChange(EnvironmentTickContext<class_3222> context) {
        if (context.affected().method_7325()) {
            return 0;
        }

        TemperatureRecord temperature = context.components()
                .method_58695(EnvironmentComponentTypes.TEMPERATURE, TemperatureRecordComponent.DEFAULT);

        int total = environmentTemperatureToTemperatureChange(temperature, ScorchfulConfig.getHeatingConfig());

        if (context.affected().field_6012 % 20 == 0 && Scorchful.LOGGER.isDebugEnabled()) {
            Scorchful.LOGGER.debug("Adding {} temperature to {}", total, context.affected().method_5820());
        }

        return total;
    }

    private static TriState allowTemperatureChange(EnvironmentTickContext<class_3222> context, int temperatureChange) {
        if (temperatureChange <= 0) {
            return TriState.DEFAULT;
        }

        class_3222 player = context.affected();
        HeatingConfig config = ScorchfulConfig.getHeatingConfig();

        int tickInterval = config.getPassiveHeatingTickInterval();
        if (tickInterval > 1 && player.field_6012 % tickInterval != 0) {
            return TriState.FALSE;
        }

        if (!config.doPassiveHeating()) {
            return TriState.FALSE;
        } else {
            return TriState.of(player.thermoo$getTemperatureScale() < config.getMaxPassiveHeatingScale());
        }
    }

    static int environmentTemperatureToTemperatureChange(TemperatureRecord temperature, HeatingConfig config) {
        double temperatureC = temperature.valueInUnit(TemperatureUnit.CELSIUS);

        double thresholdC = config.getMinTemperatureForHeatC();
        double degreesPerTemperatureIncrease = config.getDegreesCPerTemperatureIncrease();

        if (temperatureC < thresholdC) {
            return 0;
        }
        // Graphical proof: https://www.desmos.com/calculator/42rvcpnxwx
        double base = (temperatureC - thresholdC + degreesPerTemperatureIncrease) / degreesPerTemperatureIncrease;
        return class_3532.method_15357(config.getEnvironmentTemperatureMultiplier() * base);
    }
}