/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.server.Sandstorms;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class SandCauldronBlock
extends class_2275 {
    public static final MapCodec<SandCauldronBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Sandstorms.SandstormType.CODEC.fieldOf("sandstorm_type").forGetter(block -> block.sandstormType), (App)class_5620.field_46590.fieldOf("interactions").forGetter(block -> block.field_27084), (App)SandCauldronBlock.method_54096()).apply((Applicative)instance, SandCauldronBlock::new));
    public static final int MIN_LEVEL = 1;
    public static final int MAX_LEVEL = 3;
    public static final class_2758 LEVEL = class_2741.field_12513;
    private static final int BASE_FLUID_HEIGHT = 6;
    private static final double FLUID_HEIGHT_PER_LEVEL = 3.0;
    private static final float FILL_WITH_SAND_CHANCE = 0.1f;
    private final Sandstorms.SandstormType sandstormType;

    public SandCauldronBlock(Sandstorms.SandstormType sandstormType, class_5620.class_8821 behaviorMap, class_4970.class_2251 settings) {
        super(settings, behaviorMap);
        this.sandstormType = sandstormType;
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3)));
    }

    public static boolean canFillWithSand(class_1937 world, Sandstorms.SandstormType sandstormType) {
        return switch (sandstormType) {
            case Sandstorms.SandstormType.RED, Sandstorms.SandstormType.REGULAR -> {
                if (world.method_8409().method_43057() < 0.1f) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public MapCodec<SandCauldronBlock> method_53969() {
        return CODEC;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return (Integer)state.method_11654((class_2769)LEVEL);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        Sandstorms.SandstormType type = Sandstorms.getCurrentSandStorm(world, pos.method_10084());
        if (this.sandstormType != type || !SandCauldronBlock.canFillWithSand(world, type) || (Integer)state.method_11654((class_2769)LEVEL) == 3) {
            return;
        }
        class_2680 filled = (class_2680)state.method_28493((class_2769)LEVEL);
        world.method_8501(pos, filled);
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)filled));
    }

    public class_1792 method_8389() {
        return class_1802.field_8638;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_10774 handler) {
    }

    protected boolean method_32765(class_3611 fluid) {
        return false;
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 3;
    }

    protected double method_31615(class_2680 state) {
        return (6.0 + (double)((Integer)state.method_11654((class_2769)LEVEL)).intValue() * 3.0) / 16.0;
    }
}

