/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.FloatSlider;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;

public class ClientConfig {
    public static final Path PATH = Scorchful.getConfigDir().resolve("client.json5");
    public static final ConfigClassHandler<ClientConfig> HANDLER = ConfigClassHandler.createBuilder(ClientConfig.class).id(Scorchful.id("client")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    private static final String CATEGORY = "main";
    @AutoGen(category="main")
    @Translate.Name(value="Do burning heart overlay")
    @SerialEntry(comment="Toggle the burning heart temperature display on the health bar")
    @TickBox
    boolean doBurningHeartOverlay = true;
    @AutoGen(category="main")
    @Translate.Name(value="Do soaking overlay")
    @TickBox
    @SerialEntry(comment="Toggle the soaking display on the health bar")
    boolean doSoakingOverlay = true;
    @AutoGen(category="main")
    @Translate.Name(value="Do Sun Hat shading")
    @TickBox
    @SerialEntry(comment="Toggle the darkening effect of the Sun Hat")
    boolean doSunHatShading = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable sound temperature effects")
    @TickBox
    @SerialEntry(comment="Toggle the sound effects of temperature, particularly the heart beat")
    boolean enableSoundTemperatureEffects = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable wet drip particles")
    @TickBox
    @SerialEntry(comment="Toggle the dripping particles when wet. This setting overrides Frostiful if installed.")
    boolean enableWetDripParticles = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable Heat Stroke post processing")
    @TickBox
    @SerialEntry(comment="Toggle the blur and wavey-ness screen effects from the Heat Stroke status effect.")
    boolean enableHeatStrokePostProcessing = true;
    @AutoGen(category="main")
    @Translate.Name(value="Enable Fear post processing")
    @TickBox
    @SerialEntry(comment="Toggle the darkening and desaturation screen effects from the Heat Stroke status effect.")
    boolean enableFearPostProcessing = true;
    @AutoGen(category="main")
    @Translate.Name(value="Sun Hat shade opacity")
    @FloatSlider(min=0.0f, max=1.0f, step=0.05f)
    @SerialEntry(comment="Controls how dark the sun hat shading is.")
    float sunHatShadeOpacity = 0.2f;

    public float getSunHatShadeOpacity() {
        return this.doSunHatShading ? this.sunHatShadeOpacity : 0.0f;
    }

    public boolean enableSoundTemperatureEffects() {
        return this.enableSoundTemperatureEffects;
    }

    public boolean enableWetDripParticles() {
        return this.enableWetDripParticles;
    }

    public boolean enableHeatStrokePostProcessing() {
        return this.enableHeatStrokePostProcessing;
    }

    public boolean enableFearPostProcessing() {
        return this.enableFearPostProcessing;
    }

    public boolean doBurningHeartOverlay() {
        return this.doBurningHeartOverlay;
    }

    public boolean doSoakingOverlay() {
        return this.doSoakingOverlay;
    }
}

