/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import com.github.thedeathlycow.scorchful.item.FireChargeThrower;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleField;
import dev.isxander.yacl3.config.v2.api.autogen.EnumCycler;
import dev.isxander.yacl3.config.v2.api.autogen.FloatField;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;

public class CombatConfig {
    public static final Path PATH = Scorchful.getConfigDir().resolve("combat.json5");
    public static final ConfigClassHandler<CombatConfig> HANDLER = ConfigClassHandler.createBuilder(CombatConfig.class).id(Scorchful.id("combat")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    private static final String CATEGORY = "main";
    @AutoGen(category="main")
    @Translate.Name(value="Fireball throwing type")
    @SerialEntry(comment="Controls what type of fireball is creating when throwing a fire charge. Small is just like firing from a Dispener and creates a fire on impact. Large is more like a Ghast and creates an explosion, and disabled disables this feature.")
    @EnumCycler
    FireChargeThrower.FireballFactory fireBallThrownType = FireChargeThrower.FireballFactory.SMALL;
    @AutoGen(category="main")
    @Translate.Name(value="Enable desert visions")
    @SerialEntry(comment="Toggles hallucinations when overheating in the desert like boats and flowers.")
    @TickBox
    boolean enableDesertVisions = true;
    @AutoGen(category="main")
    @Translate.Name(value="Fire Protection heat resistance per level")
    @SerialEntry(comment="How much Heat Resistance the Fire Protection enchantment should give, per level of Fire Protection.")
    @DoubleField
    double fireProtectionHeatResistancePerLevel = 0.125;
    @AutoGen(category="main")
    @Translate.Name(value="Fear detection range multiplier")
    @SerialEntry(comment="How much to multiply an entity's (including players) hostile mob detection range by.")
    @DoubleField(min=0.0, max=128.0)
    double fearDetectionRangeMultiplier = 2.0;
    @AutoGen(category="main")
    @Translate.Name(value="Impaling damage per level")
    @SerialEntry(comment="How much damage the Impaling enchantment should do to wet entities, per level of Impaling")
    @FloatField(min=0.0f)
    float impalingDamagePerLevel = 2.5f;

    public FireChargeThrower.FireballFactory getFireBallThrownType() {
        return this.fireBallThrownType;
    }

    public boolean enableDesertVisions() {
        return this.enableDesertVisions;
    }

    public double getFireProtectionHeatResistancePerLevel() {
        return this.fireProtectionHeatResistancePerLevel;
    }

    public double getFearDetectionRangeMultiplier() {
        return this.fearDetectionRangeMultiplier;
    }

    public float getImpalingDamagePerLevel() {
        return this.impalingDamagePerLevel;
    }
}

