/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config.section;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.Translate;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.autogen.AutoGen;
import dev.isxander.yacl3.config.v2.api.autogen.DoubleSlider;
import dev.isxander.yacl3.config.v2.api.autogen.IntSlider;
import dev.isxander.yacl3.config.v2.api.autogen.TickBox;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;

public class WeatherConfig {
    public static final Path PATH = Scorchful.getConfigDir().resolve("weather.json5");
    public static final ConfigClassHandler<WeatherConfig> HANDLER = ConfigClassHandler.createBuilder(WeatherConfig.class).id(Scorchful.id("weather")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    private static final String CATEGORY = "main";
    @AutoGen(category="main")
    @Translate.Name(value="Do Sand Pile accumulation")
    @SerialEntry(comment="Enable/disable sand piles accumulating on the ground during sandstorms.")
    @TickBox
    boolean doSandPileAccumulation = true;
    @AutoGen(category="main")
    @Translate.Name(value="Sand Pile accumulation height")
    @SerialEntry(comment="Sets the maximum height of sand piles that can accumulate during sand storms. Maximum value is 8.")
    @IntSlider(min=0, max=8, step=1)
    int sandPileAccumulationHeight = 1;
    @AutoGen(category="main")
    @Translate.Name(value="Sandstorm Slowness amount (percent from -1 to +1)")
    @SerialEntry(comment="How much to multiply the total speed of entities on the surface by during Sandstorms. Negative values provide slowness, positive values provide speed.")
    @DoubleSlider(min=-1.0, max=1.0, step=0.1)
    double sandstormSlownessAmountPercent = -0.3;
    @AutoGen(category="main")
    @Translate.Name(value="Sandstorm Follow Range reduction amount (percent from -1 to +1)")
    @SerialEntry(comment="How much to multiply the total follow range of entities on the surface by during Sandstorms. Negative values decrease follow range, positive values increase it.")
    @DoubleSlider(min=-1.0, max=1.0, step=0.1)
    double sandstormFollowRangeReductionPercent = -0.5;

    public boolean isSandPileAccumulationEnabled() {
        return this.doSandPileAccumulation;
    }

    public int getSandPileAccumulationHeight() {
        return this.sandPileAccumulationHeight;
    }

    public double getSandstormSlownessAmountPercent() {
        return this.sandstormSlownessAmountPercent;
    }

    public double getSandstormFollowRangeReductionPercent() {
        return this.sandstormFollowRangeReductionPercent;
    }
}

