/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.hud;

import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.hud.BurningHeartsOverlay;
import com.github.thedeathlycow.thermoo.api.client.HeartBarContext;
import com.github.thedeathlycow.thermoo.api.client.StatusBarOverlayRenderEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_332;
import org.joml.Vector2i;

@Environment(value=EnvType.CLIENT)
public final class MountHealthOverlay
implements StatusBarOverlayRenderEvents.RenderMountHealthBarCallback {
    public static final MountHealthOverlay INSTANCE = new MountHealthOverlay();

    public void render(class_332 context, class_1657 player, class_1309 mount, HeartBarContext heartBarContext) {
        if (!ScorchfulConfig.getClientConfig().doBurningHeartOverlay() || mount.thermoo$isCold()) {
            return;
        }
        int fireHalfHearts = BurningHeartsOverlay.getNumFireHalfHearts(mount, heartBarContext.positions().size());
        int fireHearts = BurningHeartsOverlay.getNumFireHearts(fireHalfHearts);
        boolean drawHalfHeartAtEnd = fireHalfHearts % 2 != 0;
        int heartsRendered = 0;
        for (Vector2i position : heartBarContext.positions()) {
            boolean isHalfHeart;
            if (heartsRendered >= fireHearts) break;
            int x = position.x();
            int y = position.y() - 1;
            boolean bl = isHalfHeart = drawHalfHeartAtEnd && heartsRendered == fireHearts - 1;
            if (isHalfHeart) {
                context.method_25290(class_10799.field_56883, BurningHeartsOverlay.HEART_OVERLAY_TEXTURE, x + 4, y, 4.0f, 0.0f, 5, 10, 18, 30);
            } else {
                context.method_25290(class_10799.field_56883, BurningHeartsOverlay.HEART_OVERLAY_TEXTURE, x, y, 0.0f, 0.0f, 9, 10, 18, 30);
            }
            ++heartsRendered;
        }
    }

    private MountHealthOverlay() {
    }
}

