/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.WeatherConfig;
import com.github.thedeathlycow.scorchful.registry.tag.SEntityTypeTags;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;

public class SandstormSlowing {
    private static final class_2960 SPEED_MODIFIER_ID = Scorchful.id("sandstorm_slowing");
    private static final class_2960 FOLLOW_RANGE_MODIFIER_ID = Scorchful.id("sandstorm_reduced_visibility");

    public static boolean tickSandstormSlow(class_1309 entity, boolean wasInSandstorm) {
        if (entity.method_5864().method_20210(SEntityTypeTags.DOES_NOT_SLOW_IN_SANDSTORM)) {
            return false;
        }
        class_1937 world = entity.method_73183();
        class_2338 pos = entity.method_24515();
        if (world.method_8608()) {
            return false;
        }
        if (Sandstorms.getCurrentSandStorm(world, pos) == Sandstorms.SandstormType.NONE) {
            if (wasInSandstorm) {
                SandstormSlowing.removeModifiers(entity);
            }
            return false;
        }
        if (!wasInSandstorm) {
            SandstormSlowing.addSlow(entity);
        }
        return true;
    }

    private static void removeModifiers(class_1309 entity) {
        SandstormSlowing.removeModifier(entity, (class_6880<class_1320>)class_5134.field_23719, SPEED_MODIFIER_ID);
        SandstormSlowing.removeModifier(entity, (class_6880<class_1320>)class_5134.field_23717, FOLLOW_RANGE_MODIFIER_ID);
    }

    private static void addSlow(class_1309 entity) {
        WeatherConfig config = ScorchfulConfig.getWeatherConfig();
        SandstormSlowing.addModifier(entity, (class_6880<class_1320>)class_5134.field_23719, SPEED_MODIFIER_ID, config.getSandstormSlownessAmountPercent(), class_1322.class_1323.field_6331);
        SandstormSlowing.addModifier(entity, (class_6880<class_1320>)class_5134.field_23717, FOLLOW_RANGE_MODIFIER_ID, config.getSandstormFollowRangeReductionPercent(), class_1322.class_1323.field_6331);
    }

    private static void addModifier(class_1309 entity, class_6880<class_1320> attribute, class_2960 modifierID, double value, class_1322.class_1323 operation) {
        class_1324 instance = entity.method_5996(attribute);
        if (instance != null) {
            instance.method_26835(new class_1322(modifierID, value, operation));
        }
    }

    private static void removeModifier(class_1309 entity, class_6880<class_1320> attribute, class_2960 modifierID) {
        class_1324 instance = entity.method_5996(attribute);
        if (instance != null && instance.method_6199(modifierID) != null) {
            instance.method_6200(modifierID);
        }
    }

    private SandstormSlowing() {
    }
}

