/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.HeatingConfig;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntityTemperatureTickEvents;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;

public final class ActiveTemperatureEffects {
    public static void initialize() {
        LivingEntityTemperatureTickEvents.GET_ACTIVE_TEMPERATURE_CHANGE.register(ActiveTemperatureEffects::getActiveChange);
    }

    private static int getActiveChange(EnvironmentTickContext<? extends class_1309> context) {
        class_1309 entity = (class_1309)context.affected();
        if (entity.method_7325() || entity.thermoo$getTemperature() < 0) {
            return 0;
        }
        int total = 0;
        HeatingConfig config = ScorchfulConfig.getHeatingConfig();
        total += ActiveTemperatureEffects.getOnFireTemperatureChange(entity, config);
        total += ActiveTemperatureEffects.getInLavaTemperatureChange(entity, config);
        return total += ActiveTemperatureEffects.getPowderSnowTemperatureChange(entity, config);
    }

    private static int getOnFireTemperatureChange(class_1309 entity, HeatingConfig config) {
        if (entity.thermoo$canOverheat() && entity.method_5809() && !entity.method_5753()) {
            return entity.method_6059(class_1294.field_5918) ? config.getOnFireWarmRateWithFireResistance() : config.getOnFireWarmRate();
        }
        return 0;
    }

    private static int getInLavaTemperatureChange(class_1309 entity, HeatingConfig config) {
        if (entity.method_5771()) {
            return config.getInLavaWarmRate();
        }
        if (entity.method_5864() == class_1299.field_23214) {
            return -config.getStriderOutOfLavaCoolRate();
        }
        return 0;
    }

    private static int getPowderSnowTemperatureChange(class_1309 entity, HeatingConfig config) {
        if (entity.field_28628 && entity.thermoo$canFreeze()) {
            return -config.getPowderSnowCoolRate();
        }
        return 0;
    }

    private ActiveTemperatureEffects() {
    }
}

