package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.item.WaterSkinItem;
import com.github.thedeathlycow.scorchful.item.component.DrinkContainerComponent;
import com.github.thedeathlycow.scorchful.registry.SItems;
import com.github.thedeathlycow.scorchful.registry.SStats;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;

public class NetherLilyBehaviours {
    public static final NetherLilyBehaviour.NetherLilyBehaviourMap WARPED_LILY_BEHAVIOUR = NetherLilyBehaviour.createMap("scorchful_warped_lily");

    public static final NetherLilyBehaviour.NetherLilyBehaviourMap CRIMSON_LILY_BEHAVIOUR = NetherLilyBehaviour.createMap("scorchful_crimson_lily");

    private static final NetherLilyBehaviour ADD_WATER = (state, world, pos, player, hand, stack) -> {
        if (!world.field_9236) {
            if (state.method_11654(NetherLilyBlock.WATER_SATURATION_LEVEL) >= NetherLilyBlock.MAX_LEVEL) {
                return class_1269.field_5814;
            }
            class_1792 item = stack.method_7909();
            player.method_7281(SStats.FILL_CRIMSON_LILY);
            player.method_7259(class_3468.field_15372.method_14956(item));
            NetherLilyBlock.setWater(state, world, pos, 3);
            world.method_8396(
                    null,
                    pos,
                    class_3417.field_14779, class_3419.field_15245,
                    1.0f, 1.0f
            );
            world.method_33596(null, class_5712.field_28167, pos);
        }
        return class_1269.field_5812;
    };

    public static void initialize() {
        WARPED_LILY_BEHAVIOUR.map().put(
                class_1802.field_8469,
                (state, world, pos, player, hand, stack) -> {

                    if (state.method_11654(NetherLilyBlock.WATER_SATURATION_LEVEL) < 3) {
                        return class_1269.field_5814;
                    }

                    if (!world.field_9236) {
                        class_1792 item = stack.method_7909();
                        player.method_6122(
                                hand,
                                class_5328.method_30012(
                                        stack,
                                        player,
                                        class_1844.method_57400(class_1802.field_8574, class_1847.field_8991)
                                )
                        );
                        player.method_7281(SStats.USE_WARPED_LILY);
                        player.method_7259(class_3468.field_15372.method_14956(item));
                        NetherLilyBlock.setWater(state, world, pos, 0);
                        world.method_8396(
                                null,
                                pos,
                                class_3417.field_14779, class_3419.field_15245,
                                1.0f, 1.0f
                        );
                        world.method_33596(null, class_5712.field_28167, pos);
                    }
                    return class_1269.field_5812;
                }
        );
        WARPED_LILY_BEHAVIOUR.map().put(SItems.WATER_SKIN, ((WaterSkinItem) SItems.WATER_SKIN)::onWarpedLilyInteract);

        CRIMSON_LILY_BEHAVIOUR.map().put(
                class_1802.field_8574,
                (state, world, pos, player, hand, stack) -> {

                    class_1269 result = ADD_WATER.interact(state, world, pos, player, hand, stack);

                    if (!world.field_9236 && result.method_23665()) {
                        player.method_6122(
                                hand,
                                class_5328.method_30012(stack, player, new class_1799(class_1802.field_8469))
                        );
                    }

                    return result;
                }
        );
        CRIMSON_LILY_BEHAVIOUR.map().put(
                SItems.WATER_SKIN,
                (state, world, pos, player, hand, stack) -> {
                    class_1269 result;
                    if (WaterSkinItem.hasDrink(stack)) {
                        result = ADD_WATER.interact(state, world, pos, player, hand, stack);
                    } else {
                        result = class_1269.field_52423;
                    }

                    if (!world.field_9236 && result.method_23665()) {
                        DrinkContainerComponent.addDrinks(stack, -1);
                    }
                    return result;
                }
        );

    }

    private NetherLilyBehaviours() {

    }
}
