package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.registry.SBlockProperties;
import com.github.thedeathlycow.scorchful.registry.tag.SBlockTags;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;

public class NetherLilyBlock extends class_2248 {

    public static final MapCodec<NetherLilyBlock> field_46280 = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            NetherLilyBehaviour.CODEC
                                    .fieldOf("behaviors")
                                    .forGetter(block -> block.behaviorMap),
                            method_54096()
                    )
                    .apply(instance, NetherLilyBlock::new)
    );

    public static final int MIN_LEVEL = 0;

    public static final int MAX_LEVEL = 3;

    public static final class_2758 WATER_SATURATION_LEVEL = SBlockProperties.WATER_LEVEL_0_3;

    private static final class_265 SHAPE = class_2248.method_9541(
            2.0, 0.0, 2.0,
            14.0, 3.0, 14.0
    );

    private final NetherLilyBehaviour.NetherLilyBehaviourMap behaviorMap;

    public NetherLilyBlock(NetherLilyBehaviour.NetherLilyBehaviourMap behaviorMap, class_2251 settings) {
        super(settings);
        this.behaviorMap = behaviorMap;
        this.method_9590(
                this.method_9564()
                        .method_11657(WATER_SATURATION_LEVEL, 0)
        );
    }

    public static void setWater(class_2680 state, class_1937 world, class_2338 pos, int level) {
        class_2680 blockState = state.method_11657(WATER_SATURATION_LEVEL, level);
        world.method_8501(pos, blockState);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(blockState));
    }

    @Override
    protected MapCodec<? extends NetherLilyBlock> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(WATER_SATURATION_LEVEL);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return class_2248.method_20044(world, pos.method_10074(), class_2350.field_11036) && !world.method_22351(pos);
    }

    @Override
    protected class_2680 method_9559(
            class_2680 state,
            class_4538 world,
            class_10225 tickView,
            class_2338 pos,
            class_2350 direction,
            class_2338 neighborPos,
            class_2680 neighborState,
            class_5819 random
    ) {
        if (direction == class_2350.field_11033 && !this.method_9558(state, world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public class_1269 method_55765(
            class_1799 stack, class_2680 state,
            class_1937 world, class_2338 pos,
            class_1657 player, class_1268 hand,
            class_3965 hit
    ) {
        NetherLilyBehaviour behaviour = this.behaviorMap.map().get(stack.method_7909());
        return behaviour.interact(state, world, pos, player, hand, stack);
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return state.method_11654(WATER_SATURATION_LEVEL) < 3;
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        int saturationLevel = state.method_11654(WATER_SATURATION_LEVEL);

        if (saturationLevel != MAX_LEVEL) {
            return;
        }

        double x = pos.method_10263() + random.method_43058();
        double y = pos.method_10264() + (random.method_43058() / 4.0);
        double z = pos.method_10260() + random.method_43058();

        class_2394 particle = random.method_43057() < 0.25f
                ? class_2398.field_28078
                : class_2398.field_11232;

        world.method_8406(
                particle,
                x, y, z,
                0, 0, 0
        );
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {

        if (world.field_9236) {
            return;
        }

        class_2874 dimension = world.method_8597();
        if (dimension.comp_644()) {
            class_2680 below = world.method_8320(pos.method_10074());
            if (below.method_26164(SBlockTags.NETHER_LILY_CAN_ABSORB_WATER)) {
                this.tryGrow(state, world, pos, random);
            }
        } else {
            this.tryGrow(state, world, pos, random);
        }
    }

    private void tryGrow(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int saturation = state.method_11654(WATER_SATURATION_LEVEL);
        if (saturation >= MAX_LEVEL) {
            return;
        }

        Scorchful.LOGGER.debug("Grew a nether lily at {}", pos);
        world.method_8652(pos, state.method_11657(WATER_SATURATION_LEVEL, saturation + 1), class_2248.field_31028);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }
}
