package com.github.thedeathlycow.scorchful.block;

import com.github.thedeathlycow.scorchful.registry.tag.SBlockTags;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SandPileBlock extends class_2346 {

    public static final MapCodec<SandPileBlock> CODEC = RecordCodecBuilder.mapCodec(
            instance -> instance.group(
                            Codec.INT
                                    .fieldOf("color")
                                    .forGetter(b -> b.color),
                            method_54096()
                    )
                    .apply(instance, SandPileBlock::new)
    );

    public static final int MAX_LAYERS = 8;
    public static final class_2758 LAYERS = class_2741.field_12536;
    protected static final class_265[] LAYERS_TO_SHAPE = new class_265[]{
            class_259.method_1073(),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 2.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 4.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 6.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 8.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 10.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 12.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 14.0, 16.0),
            class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)
    };
    public static final int MAX_PATH_FINDING_LAYERS = 5;
    private final int color;

    public SandPileBlock(int color, class_2251 settings) {
        super(settings);
        this.color = color;
        this.method_9590(this.method_9564().method_11657(LAYERS, 1));
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 type) {
        return switch (type) {
            case field_50 -> state.method_11654(LAYERS) < MAX_PATH_FINDING_LAYERS;
            case field_48, field_51 -> false;
        };
    }

    @Override
    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 anchorState = world.method_8320(pos.method_10074());
        if (anchorState.method_26164(SBlockTags.SAND_PILE_CANNOT_SURVIVE_ON)) {
            return false;
        }
        if (anchorState.method_26164(SBlockTags.SAND_PILE_CAN_SURVIVE_ON)) {
            return true;
        }

        return class_2248.method_9501(anchorState.method_26220(world, pos.method_10074()), class_2350.field_11036)
                || (anchorState.method_26204() instanceof SandPileBlock) && anchorState.method_11654(LAYERS) >= MAX_LAYERS;
    }

    @Override
    protected MapCodec<? extends class_2346> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!this.method_9558(state, world, pos)) {
            super.method_9588(state, world, pos, random);
        }
    }

    @Override
    protected boolean method_9526(class_2680 state) {
        return true;
    }

    @Override
    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return state.method_11654(LAYERS) == MAX_LAYERS ? 0.2f : 1.0f;
    }

    @Override
    protected boolean method_9616(class_2680 state, class_1750 context) {
        int i = state.method_11654(LAYERS);
        if (context.method_8041().method_31574(this.method_8389()) && i < MAX_LAYERS) {
            if (context.method_7717()) {
                return context.method_8038() == class_2350.field_11036;
            }
            return true;
        }
        return i == 1;
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = ctx.method_8045().method_8320(ctx.method_8037());
        if (blockState.method_27852(this)) {
            int i = blockState.method_11654(LAYERS);
            return blockState.method_11657(LAYERS, Math.min(MAX_LAYERS, i + 1));
        }
        return super.method_9605(ctx);
    }

    @Override
    public int method_10130(class_2680 state, class_1922 world, class_2338 pos) {
        return this.color;
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS)];
    }

    @Override
    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS) - 1];
    }

    @Override
    protected class_265 method_25959(class_2680 state, class_1922 world, class_2338 pos) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS)];
    }

    @Override
    protected class_265 method_26159(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return LAYERS_TO_SHAPE[state.method_11654(LAYERS)];
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(LAYERS);
    }
}
