package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import com.github.thedeathlycow.scorchful.particle.DustGrainParticleEffect;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import com.github.thedeathlycow.scorchful.util.SMth;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_6854;
import net.minecraft.class_6880;
import net.minecraft.class_758;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SandstormEffects {

    public static final class_243 REGULAR_SANDSTORM_FOG_COLOR = class_243.method_24457(0xD9AA84);
    public static final Vector3f REGULAR_SANDSTORM_PARTICLE_COLOR = class_243.method_24457(0xD9AA84).method_46409();

    private static final float START_FOG_SPHERE_RAIN_GRADIENT = 0.75f;

    private static final float PARTICLE_SCALE = 10f;

    public static boolean shouldCancelClouds(class_638 world, class_2338 pos) {
        return world.method_8430(1f) > SandstormEffects.START_FOG_SPHERE_RAIN_GRADIENT
                && Sandstorms.isSandStorming(world, pos);
    }

    public static void tickSandstormParticles(class_638 clientWorld) {
        if (!clientWorld.method_8419() || clientWorld.method_54719().method_54754()) {
            return;
        }

        final ClientConfig config = Scorchful.getConfig().clientConfig;
        final int renderDistance = config.getSandStormParticleRenderDistance();
        if (!config.isSandstormParticlesEnabled() || renderDistance <= 0) {
            return; // config disabled
        }

        final class_310 gameClient = class_310.method_1551();
        final class_4184 camera = gameClient.field_1773.method_19418();
        if (camera == null) {
            return; // no camera for whatever reason
        }

        // main particle loop
        final class_2338 cameraPos = camera.method_19328();
        final class_2338.class_2339 pos = new class_2338.class_2339();
        final class_2394 particle = new DustGrainParticleEffect(REGULAR_SANDSTORM_PARTICLE_COLOR, PARTICLE_SCALE);
        final int rarity = config.getSandStormParticleRarity();
        final int cameraY = cameraPos.method_10264();
        final float particleVelocity = config.getSandStormParticleVelocity();

        for (int x = cameraPos.method_10263() - renderDistance; x < cameraPos.method_10263() + renderDistance; x++) {
            for (int z = cameraPos.method_10260() - renderDistance; z < cameraPos.method_10260() + renderDistance; z++) {
                int y = cameraY + clientWorld.field_9229.method_39332(-renderDistance / 2, (renderDistance + 1) / 2);
                y = Math.max(y, clientWorld.method_8624(class_2902.class_2903.field_13197, x, z));
                pos.method_10103(x, y, z);
                addParticle(clientWorld, particle, pos, rarity, particleVelocity);
            }
        }
    }

    @Nullable
    public static class_243 getFogColor(
            class_638 world, class_4184 camera,
            float baseRed, float baseGreen, float baseBlue,
            float tickDelta
    ) {
        ClientConfig config = Scorchful.getConfig().clientConfig;

        if (!config.isSandstormFogEnabled()) {
            return null;
        }

        float gradient = world.method_8430(1f);
        if (gradient > 0f && Sandstorms.isSandStorming(world, camera.method_19328())) {
            final var normalColor = new class_243(baseRed, baseGreen, baseBlue);
            class_243 adjustedColor = SMth.lerp(gradient, normalColor, SandstormEffects.REGULAR_SANDSTORM_FOG_COLOR);

            // idk why the game does this transformation but ill do it here too for consistency
            float skyAngle = class_3532.method_15363(
                    class_3532.method_15362(world.method_30274(tickDelta) * 2 * class_3532.field_29844) * 2.0F + 0.5F,
                    0.0F, 1.0F
            );

            final class_243 sandStormColor = adjustedColor;
            var samplePos = new class_2338.class_2339();
            adjustedColor = class_6491.method_24895(
                    camera.method_19326(),
                    (x, y, z) -> {
                        samplePos.method_10103(x, y, z);
                        class_6880<class_1959> biome = world.method_23753(samplePos);
                        return world.method_28103().method_28112(
                                Sandstorms.hasSandStorms(biome)
                                        ? sandStormColor
                                        : normalColor,
                                skyAngle
                        );
                    }
            );

            return adjustedColor;
        }
        return null;
    }

    public static void updateFogDistance(
            class_4184 camera,
            float viewDistance,
            class_5636 cameraSubmersionType,
            class_758.class_7285 fogData
    ) {
        ClientConfig config = Scorchful.getConfig().clientConfig;

        if (!config.isSandstormFogEnabled()) {
            return;
        }

        class_1297 focused = camera.method_19331();
        class_1937 world = focused.method_37908();
        final float rainGradient = world.method_8430(1f);
        if (cameraSubmersionType == class_5636.field_27888 && rainGradient > 0f) {
            class_2338 pos = camera.method_19328();
            if (Sandstorms.isSandStorming(world, pos)) {
                var samplePos = new class_2338.class_2339();
                final var baseRadius = new class_243(fogData.field_38340, fogData.field_38341, 0);
                final var fogRadius = new class_243(
                        config.getSandStormFogStart(),
                        config.getSandStormFogEnd(),
                        0
                );

                // tri lerp fog distances to make less jarring biome transition
                // start is stored in X and end in Y
                class_243 fogDistances = class_6491.method_24895(camera.method_19326(), (x, y, z) -> {
                    samplePos.method_10103(x, y, z);
                    if (Sandstorms.hasSandStorms(world.method_23753(samplePos))) {
                        return fogRadius;
                    }
                    return baseRadius;
                });

                // lerp fog distances for smooth transition when weather changes
                updateFogRadius(fogData, fogDistances, rainGradient);
            }
        }
    }

    private static void updateFogRadius(class_758.class_7285 fogData, class_243 fogDistances, float rainGradient) {
        fogData.field_38340 = class_3532.method_16439(rainGradient, fogData.field_38340, (float) fogDistances.field_1352);
        fogData.field_38341 = class_3532.method_16439(rainGradient, fogData.field_38341, (float) fogDistances.field_1351);

        if (rainGradient > START_FOG_SPHERE_RAIN_GRADIENT) {
            fogData.field_38342 = class_6854.field_36350;
        }
    }

    private static void addParticle(class_638 world, class_2394 particle, class_2338 pos, int rarity, float velocity) {
        if (Sandstorms.getCurrentSandStorm(world, pos) != Sandstorms.SandstormType.NONE && world.field_9229.method_43048(rarity) == 0) {
            world.method_8406(
                    particle,
                    pos.method_10263() + world.field_9229.method_43058(),
                    pos.method_10264() + world.field_9229.method_43058(),
                    pos.method_10260() + world.field_9229.method_43058(),
                    velocity, 0, 0
            );
        }
    }

    private SandstormEffects() {

    }
}
