package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.registry.SSoundEvents;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4184;
import net.minecraft.class_638;

public class SandstormSounds {

    public static final SandstormSounds INSTANCE = new SandstormSounds();

    private static final int MAX_SOUND_Y_DIFF = 10;

    private static final int MAX_XZ_OFFSET = 10;

    private int timer = 0;

    public void tick(class_638 world) {

        if (world.method_54719().method_54754() || !Scorchful.getConfig().clientConfig.isSandstormSoundsEnabled()) {
            return;
        }

        final class_310 gameClient = class_310.method_1551();
        final class_4184 camera = gameClient.field_1773.method_19418();
        if (camera == null) {
            return; // no camera for whatever reason
        }

        if (!world.method_8419()) {
            return;
        }

        if (world.field_9229.method_43048(3) >= this.timer) {
            this.timer++;
            return;
        }
        this.timer = 0;

        this.chooseSpotForWindSound(world, camera).ifPresent(
                pos -> {
                    world.method_45446(
                            pos,
                            SSoundEvents.WEATHER_SANDSTORM,
                            class_3419.field_15252,
                            0.1f, 0.5f,
                            false
                    );
                }
        );

    }

    private Optional<class_2338> chooseSpotForWindSound(class_638 world, class_4184 camera) {

        class_2338 cameraPos = camera.method_19328();

        int dx = world.field_9229.method_39332(-MAX_XZ_OFFSET, MAX_SOUND_Y_DIFF);
        int dy = world.field_9229.method_39332(-MAX_XZ_OFFSET, MAX_SOUND_Y_DIFF);
        int dz = world.field_9229.method_39332(-MAX_XZ_OFFSET, MAX_SOUND_Y_DIFF);
        class_2338 soundPos = cameraPos.method_10069(dx, dy, dz);

        if (Sandstorms.getCurrentSandStorm(world, soundPos) != Sandstorms.SandstormType.NONE) {
            return Optional.of(soundPos);
        }

        return Optional.empty();
    }

    private SandstormSounds() {

    }
}
