package com.github.thedeathlycow.scorchful.client;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ClientConfig;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1291;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_9779;
import net.minecraft.class_9920;
import net.minecraft.class_9960;
import java.util.function.Predicate;

public final class ShaderStatusEffectManager implements ShaderEffectRenderCallback, ClientPlayConnectionEvents.Disconnect {

//    private final ManagedShaderEffect managedShaderEffect;

    private final class_2960 shaderID;

    private final class_6880<class_1291> potionEffect;

    private final Predicate<ClientConfig> enabledPredicate;

    private boolean enabled = false;

    public ShaderStatusEffectManager(
//            ManagedShaderEffect managedShaderEffect,
            class_2960 shaderID,
            class_6880<class_1291> potionEffect,
            Predicate<ClientConfig> enabledPredicate
    ) {
//        this.managedShaderEffect = managedShaderEffect;
        this.shaderID = shaderID;
        this.potionEffect = potionEffect;
        this.enabledPredicate = enabledPredicate;
    }

    public void onEffectAdded(class_6880<class_1291> addedEffect) {
        if (addedEffect == potionEffect && this.enabledPredicate.test(Scorchful.getConfig().clientConfig)) {
            enabled = true;
        }
    }

    public void onEffectRemoved(class_6880<class_1291> removedEffect) {
        if (removedEffect == potionEffect) {
            enabled = false;
        }
    }

    public void onPlayerRespawn() {
        enabled = false;
    }

    @Override
    public void onPlayDisconnect(class_634 handler, class_310 client) {
        this.enabled = false;
    }

    @Override
    public void renderShaderEffects(class_310 client, class_9920 pool, class_9779 tickDelta) {
        if (enabled) {
//            this.managedShaderEffect.render(tickDelta);
            class_279 postEffectProcessor = client.method_62887()
                    .method_62941(this.shaderID, class_9960.field_53902);
            if (postEffectProcessor != null) {
                postEffectProcessor.method_1258(client.method_1522(), pool);
            }
        }
    }
}
