package com.github.thedeathlycow.scorchful.components;

import com.github.thedeathlycow.scorchful.api.ServerThirstPlugin;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerWaterComponent implements Component, ServerTickingComponent {

    public static final int MAX_WATER = 300;

    private static final String WATER_KEY = "body_water";

    private static final String REHYDRATION_DRINK_KEY = "rehydration_drink";


    private final class_1657 provider;

    private int waterDrunk = 0;

    public PlayerWaterComponent(class_1657 provider) {
        this.provider = provider;
    }

    public int getWaterDrunk() {
        return waterDrunk;
    }

    public void drink(int amount) {
        this.waterDrunk = class_3532.method_15340(this.waterDrunk + amount, 0, MAX_WATER);
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10573(WATER_KEY, class_2520.field_33253)) {
            this.waterDrunk = tag.method_10550(WATER_KEY);
        }
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.waterDrunk > 0) {
            tag.method_10569(WATER_KEY, this.waterDrunk);
        }
    }

    @Override
    public void serverTick() {
        if (!this.provider.thermoo$isCold() && ServerThirstPlugin.getActivePlugin().dehydrateFromSweating(this.provider)) {
            // sweating: move thirst water to wetness
            this.provider.thermoo$addWetTicks(2);
        }
    }
}
