package com.github.thedeathlycow.scorchful.entity.effect;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.registry.SParticleTypes;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.registry.tag.SEntityTypeTags;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_4081;

public class FearStatusEffect extends class_1291 {
    public FearStatusEffect(class_4081 category, int color) {
        super(category, color, SParticleTypes.BAT);
    }

    public static boolean canHaveFear(class_1309 entity, class_1293 effectInstance) {
        if (effectInstance.method_55654(SStatusEffects.FEAR)) {
            if (entity.method_5864().method_20210(SEntityTypeTags.IMMUNE_TO_FEAR)) {
                return false;
            } else {
                return entity.method_31747() || entity instanceof class_1314;
            }
        }

        return true;
    }

    public static boolean isFeared(class_1297 target) {
        return target instanceof class_1309 livingTarget
                && livingTarget.method_6059(SStatusEffects.FEAR);
    }

    public static double modifyDetectionDistance(class_1309 target, double original) {
        return target.method_6059(SStatusEffects.FEAR)
                ? Scorchful.getConfig().combatConfig.getFearDetectionRangeMultiplier() * original
                : original;
    }

}
