package com.github.thedeathlycow.scorchful.entity.feature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.entity.model.SunHatModel;
import com.github.thedeathlycow.scorchful.entity.state.SLivingEntityRenderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10034;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;

@Environment(EnvType.CLIENT)
public class SunHatFeatureRenderer<S extends class_10034, M extends class_572<S>> extends class_3887<S, M> {

    private static final class_2960 TEXTURE = Scorchful.id("textures/entity/sun_hat.png");

    private final SunHatModel<S> model;

    public SunHatFeatureRenderer(class_3883<S, M> context, SunHatModel<S> model) {
        super(context);
        this.model = model;
    }

    @Override
    public void render(
            class_4587 matrices,
            class_4597 vertexConsumers,
            int light,
            S state,
            float limbAngle,
            float limbDistance
    ) {
        if (((SLivingEntityRenderState) state).scorchful$hasSunHat()) {
            this.method_17165().method_64254(this.model);
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448(TEXTURE));
            this.model.renderHead(matrices, vertexConsumer, light, class_4608.field_21444, -1);
        }
    }
}
