package com.github.thedeathlycow.scorchful.mixin;

import com.github.thedeathlycow.scorchful.entity.effect.FearStatusEffect;
import com.github.thedeathlycow.scorchful.server.SandstormSlowing;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_10209;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
    @Unique
    private boolean scorchful_wasInSandstorm = false;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(
            method = "tickMovement",
            at = @At("TAIL")
    )
    private void afterTickMovement(CallbackInfo ci) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("scorchful_sandstorm_slow");
        scorchful_wasInSandstorm = SandstormSlowing.tickSandstormSlow(
                (class_1309) (Object) this,
                scorchful_wasInSandstorm
        );
        profiler.method_15407();
    }

    @ModifyReturnValue(
            method = "getAttackDistanceScalingFactor",
            at = @At("RETURN")
    )
    private double extendMobDetectionWhenFeared(double original) {
        return FearStatusEffect.modifyDetectionDistance((class_1309) (Object) this, original);
    }

    @Inject(
            method = "canHaveStatusEffect",
            at = @At("HEAD"),
            cancellable = true
    )
    private void blockFear(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
        if (!FearStatusEffect.canHaveFear((class_1309) (Object) this, effect)) {
            cir.setReturnValue(false);
        }
    }

}
