package com.github.thedeathlycow.scorchful.mixin.client.entity.feature;

import com.github.thedeathlycow.scorchful.entity.state.SLivingEntityRenderState;
import net.minecraft.class_10042;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_976;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_976.class)
public class HeadFeatureRendererMixin<S extends class_10042, M extends class_583<S> & class_3882> {
    @Inject(
            method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/render/entity/state/LivingEntityRenderState;FF)V",
            at = @At("HEAD"),
            cancellable = true
    )
    private void cancelRenderIfSunHat(
            class_4587 matrices,
            class_4597 vertexConsumers,
            int light,
            S state,
            float limbAngle,
            float limbDistance,
            CallbackInfo ci
    ) {
        if (((SLivingEntityRenderState) state).scorchful$hasSunHat()) {
            ci.cancel();
        }
    }
}
