package com.github.thedeathlycow.scorchful.mixin.client.entity.render;

import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_897.class)
public class EntityRendererMixin<T extends class_1297> {

    @Inject(
            method = "shouldRender",
            at = @At("HEAD"),
            cancellable = true
    )
    private void shouldRender(
            T entity,
            class_4604 frustum,
            double x, double y, double z,
            CallbackInfoReturnable<Boolean> cir
    ) {
        var component = ScorchfulComponents.ENTITY_DESERT_VISION.get(entity);
        if (component.hasDesertVision()) {
            class_1657 mainPlayer = class_310.method_1551().field_1724;
            cir.setReturnValue(mainPlayer == null || mainPlayer.equals(component.getCause()));
        }
    }

}
