package com.github.thedeathlycow.scorchful.mixin.client.sandstorm;

import com.github.thedeathlycow.scorchful.client.SandstormEffects;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_758;
import net.minecraft.class_9958;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_758.class)
public class BackgroundRendererMixin { //NOSONAR
    @Inject(
            method = "getFogColor",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/world/ClientWorld$Properties;getHorizonShadingRatio()F",
                    shift = At.Shift.AFTER
            )
    )
    private static void setFogColorForSandstorm(
            class_4184 camera,
            float tickDelta,
            class_638 world,
            int clampedViewDistance,
            float skyDarkness,
            CallbackInfoReturnable<Vector4f> cir,
            @Local(ordinal = 2) LocalFloatRef red,
            @Local(ordinal = 3) LocalFloatRef green,
            @Local(ordinal = 4) LocalFloatRef blue
    ) {
        class_243 color = SandstormEffects.getFogColor(
                world, camera,
                red.get(), green.get(), blue.get(),
                tickDelta
        );

        if (color != null) {
            red.set((float) color.field_1352);
            green.set((float) color.field_1351);
            blue.set((float) color.field_1350);
        }
    }

    @Inject(
            method = "applyFog",
            at = @At("TAIL")
    )
    private static void setFogDistanceForSandstorm(
            class_4184 camera,
            class_758.class_4596 fogType,
            Vector4f color,
            float viewDistance,
            boolean thickenFog,
            float tickDelta,
            CallbackInfoReturnable<class_9958> cir,
            @Local class_5636 cameraSubmersionType,
            @Local class_758.class_7285 fogData
    ) {
        SandstormEffects.updateFogDistance(camera, viewDistance, cameraSubmersionType, fogData);
    }

}
