package com.github.thedeathlycow.scorchful.mixin.client.sandstorm;

import com.github.thedeathlycow.scorchful.client.SandstormEffects;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4063;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9909;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_761.class)
public class WorldRendererMixin {

    @Shadow private @Nullable class_638 world;

    @Inject(
            method = "renderClouds",
            at = @At("HEAD"),
            cancellable = true
    )
    private void cancelCloudsInSandstorms(class_9909 frameGraphBuilder, Matrix4f positionMatrix, Matrix4f projectionMatrix, class_4063 renderMode, class_243 cameraPos, float ticks, int color, float cloudHeight, CallbackInfo ci) {
        if (this.world != null && SandstormEffects.shouldCancelClouds(this.world, class_2338.method_49638(cameraPos))) {
            ci.cancel();
        }
    }

}
