package com.github.thedeathlycow.scorchful.mixin.thirst;

import com.github.thedeathlycow.scorchful.Scorchful;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1686;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_3857;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1686.class)
public abstract class PotionEntityMixin extends class_3857 {


    protected PotionEntityMixin(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(
            method = "onCollision",
            at = @At("HEAD")
    )
    private void onSplashPotionCollision(class_239 hitResult, CallbackInfo ci) {
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            return;
        }
        class_238 box = this.method_5829().method_1009(4.0, 2.0, 4.0);

        int waterAmount = Scorchful.getConfig().thirstConfig.getSoakingFromSplashPotions();

        world.method_18467(class_1309.class, box)
                .forEach(
                        entity -> {
                            int wetTicks = entity.thermoo$getWetTicks();
                            entity.thermoo$setWetTicks(wetTicks + waterAmount);
                        }
                );
    }

}
