package com.github.thedeathlycow.scorchful.network;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.server.network.TemperatureSoundEventPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;

public final class SoundTemperatureEffectPacketListener implements ClientPlayNetworking.PlayPayloadHandler<TemperatureSoundEventPacket> {

    @Override
    public void receive(TemperatureSoundEventPacket payload, ClientPlayNetworking.Context context) {
        if (!Scorchful.getConfig().clientConfig.enableSoundTemperatureEffects()) {
            return;
        }

        context.client().execute(() -> {
            class_310 client = context.client();

            if (client.field_1687 == null || client.field_1724 == null) {
                return;
            }

            client.field_1687.method_47967(
                    client.field_1724,
                    client.field_1724.method_23317(),
                    client.field_1724.method_23318(),
                    client.field_1724.method_23321(),
                    payload.soundEvent(),
                    payload.category(),
                    payload.volume(),
                    payload.pitch(),
                    payload.seed()
            );
        });
    }

    public SoundTemperatureEffectPacketListener() {

    }


}
