package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.block.*;
import com.github.thedeathlycow.scorchful.server.Sandstorms;
import net.minecraft.block.*;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2488;
import net.minecraft.class_2498;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4773;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.function.Function;

public final class SBlocks {
    public static final class_2248 CRIMSON_LILY = register(
            "crimson_lily",
            settings -> new CrimsonLilyBlock(
                    NetherLilyBehaviours.CRIMSON_LILY_BEHAVIOUR,
                    settings
                            .method_31710(class_3620.field_16012)
                            .method_9618()
                            .method_9634()
                            .method_9626(class_2498.field_22140)
                            .method_50012(class_3619.field_15971)
                            .method_9640()
            )
    );

    public static final class_2248 WARPED_LILY = register(
            "warped_lily",
            settings -> new NetherLilyBlock(
                    NetherLilyBehaviours.WARPED_LILY_BEHAVIOUR,
                    settings
                            .method_31710(class_3620.field_16026)
                            .method_9618()
                            .method_9634()
                            .method_9626(class_2498.field_22140)
                            .method_50012(class_3619.field_15971)
                            .method_9640()
            )
    );

    public static final class_2248 ROOTED_NETHERRACK = register(
            "rooted_netherrack",
            settings -> new class_4773(settings),
            class_4970.class_2251.method_9630(class_2246.field_10515)
    );

    public static final class_2248 ROOTED_CRIMSON_NYLIUM = register(
            "rooted_crimson_nylium",
            settings -> new RootedNyliumBlock(
                    class_2246.field_22125,
                    settings
            ),
            class_4970.class_2251.method_9630(class_2246.field_22120)
    );

    public static final class_2248 ROOTED_WARPED_NYLIUM = register(
            "rooted_warped_nylium",
            settings -> new RootedNyliumBlock(
                    class_2246.field_22116,
                    settings
            ),
            class_4970.class_2251.method_9630(class_2246.field_22113)
    );

    public static final class_2248 SAND_PILE = register(
            "sand_pile",
            settings -> new SandPileBlock(
                    0xDBD3A0,
                    settings
                            .method_51371()
                            .method_51370()
                            .method_26245((state, world, pos) -> state.method_11654(class_2488.field_11518) >= SandPileBlock.MAX_LAYERS)
                            .method_50012(class_3619.field_15971)
            ),
            class_4970.class_2251.method_9630(class_2246.field_10102)
    );

    public static final class_2248 RED_SAND_PILE = register(
            "red_sand_pile",
            settings -> new SandPileBlock(
                    0xA95821,
                    settings
                            .method_51371()
                            .method_51370()
                            .method_26245((state, world, pos) -> state.method_11654(class_2488.field_11518) >= SandPileBlock.MAX_LAYERS)
                            .method_50012(class_3619.field_15971)
            ),
            class_4970.class_2251.method_9630(class_2246.field_10534)
    );

    public static final class_2248 SAND_CAULDRON = register(
            "sand_cauldron",
            settings -> new SandCauldronBlock(
                    Sandstorms.SandstormType.REGULAR,
                    SandCauldronBehaviours.SAND_CAULDRON_BEHAVIOUR,
                    settings
            ),
            class_4970.class_2251.method_9630(class_2246.field_10593)
    );

    public static final class_2248 RED_SAND_CAULDRON = register(
            "red_sand_cauldron",
            settings -> new SandCauldronBlock(
                    Sandstorms.SandstormType.RED,
                    SandCauldronBehaviours.RED_SAND_CAULDRON_BEHAVIOUR,
                    settings
            ),
            class_4970.class_2251.method_9630(class_2246.field_10593)
    );

    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful blocks");
        SandCauldronBehaviours.initialize();
        NetherLilyBehaviours.initialize();
    }

    private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> blockFactory) {
        return register(id, blockFactory, class_4970.class_2251.method_9637());
    }

    private static class_2248 register(String id, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings) {
        class_5321<class_2248> key = class_5321.method_29179(class_7924.field_41254, Scorchful.id(id));
        class_2248 block = blockFactory.apply(settings.method_63500(key));
        return class_2378.method_39197(class_7923.field_41175, key, block);
    }

    private SBlocks() {

    }
}
