package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.item.component.DrinkContainerComponent;
import com.github.thedeathlycow.scorchful.item.component.DrinkLevelComponent;
import com.github.thedeathlycow.scorchful.item.component.HeatResistanceComponent;
import com.github.thedeathlycow.scorchful.item.component.SunHatRendererComponent;
import java.util.function.UnaryOperator;
import net.minecraft.class_2378;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public final class SDataComponentTypes {
    public static final class_9331<DrinkLevelComponent> DRINK_LEVEL = register(
            "drink_level",
            builder -> builder
                    .method_57881(DrinkLevelComponent.CODEC)
                    .method_57882(DrinkLevelComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static final class_9331<DrinkContainerComponent> DRINK_CONTAINER = register(
            "drink_container",
            builder -> builder
                    .method_57881(DrinkContainerComponent.CODEC)
                    .method_57882(DrinkContainerComponent.PACKET_CODEC)
    );

    public static final class_9331<HeatResistanceComponent> HEAT_RESISTANCE = register(
            "heat_resistance",
            builder -> builder
                    .method_57881(HeatResistanceComponent.CODEC)
                    .method_57882(HeatResistanceComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static final class_9331<SunHatRendererComponent> SUN_HAT_RENDERER = register(
            "sun_hat_renderer",
            builder -> builder
                    .method_57881(SunHatRendererComponent.CODEC)
                    .method_57882(SunHatRendererComponent.PACKET_CODEC)
                    .method_59871()
    );

    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful item components");

        class_7923.field_49658.addAlias(Scorchful.id("num_drinks"), Scorchful.id("drink_container"));
    }

    private static <T> class_9331<T> register(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(
                class_7923.field_49658,
                Scorchful.id(id),
                builderOperator.apply(class_9331.method_57873()).method_57880()
        );
    }

    private SDataComponentTypes() {

    }
}
