package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.entity.feature.SunHatFeatureRenderer;
import com.github.thedeathlycow.scorchful.entity.model.SunHatModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1007;
import net.minecraft.class_877;
import net.minecraft.class_908;
import net.minecraft.class_909;

@Environment(EnvType.CLIENT)
public class SFeatureRenderers {

    public static void registerAll() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register(
                (entityType, entityRenderer, registrationHelper, context) -> {
                    if (entityRenderer instanceof class_909<?, ?, ?> bipedEntityRenderer) {
                        registrationHelper.register(
                                new SunHatFeatureRenderer<>(
                                        bipedEntityRenderer,
                                        new SunHatModel<>(context.method_32167(SEntityModelLayers.SUN_HAT))
                                )
                        );
                    } else if (entityRenderer instanceof class_1007 playerEntityRenderer) {
                        registrationHelper.register(
                                new SunHatFeatureRenderer<>(
                                        playerEntityRenderer,
                                        new SunHatModel<>(context.method_32167(SEntityModelLayers.SUN_HAT))
                                )
                        );
                    } else if (entityRenderer instanceof class_877 armorStandEntityRenderer) {
                        registrationHelper.register(
                                new SunHatFeatureRenderer<>(
                                        armorStandEntityRenderer,
                                        new SunHatModel<>(context.method_32167(SEntityModelLayers.SUN_HAT))
                                )
                        );
                    } else if (entityRenderer instanceof class_908 giantEntityRenderer) {
                        registrationHelper.register(
                                new SunHatFeatureRenderer<>(
                                        giantEntityRenderer,
                                        new SunHatModel<>(context.method_32167(SEntityModelLayers.SUN_HAT))
                                )
                        );
                    }
                }
        );
    }

    private SFeatureRenderers() {

    }

}
