package com.github.thedeathlycow.scorchful.server;

import com.github.thedeathlycow.scorchful.registry.tag.SBiomeTags;
import com.mojang.serialization.Codec;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3542;
import net.minecraft.class_6880;

public class Sandstorms {

    public enum SandstormType implements class_3542 {
        NONE("no_sandstorm"),
        REGULAR("regular_sandstorm"),
        RED("red_sandstorm");

        public static final Codec<SandstormType> CODEC = class_3542.method_28140(SandstormType::values);

        private final String id;

        SandstormType(String id) {
            this.id = id;
        }

        @Override
        public String method_15434() {
            return this.id;
        }
    }

    /**
     * Determines if the position in the world has an active sand storm.
     *
     * @param world
     * @param pos
     * @return Returns {@link SandstormType#NONE} if it is not sand storming at the position in the world.
     * Returns {@link SandstormType#REGULAR} if it is raining in a desert and {@link SandstormType#RED} if it is raining
     * in a badlands.
     */
    public static SandstormType getCurrentSandStorm(class_1937 world, class_2338 pos, boolean includeSurface) {
        if (!world.method_8419() || (includeSurface && world.method_8520(pos))) {
            return SandstormType.NONE;
        }
        if (includeSurface && !world.method_8311(pos)) {
            return SandstormType.NONE;
        }
        if (includeSurface && world.method_8598(class_2902.class_2903.field_13197, pos).method_10264() > pos.method_10264()) {
            return SandstormType.NONE;
        }
        class_6880<class_1959> biome = world.method_23753(pos);
        if (hasRegularSandStorms(biome)) {
            return SandstormType.REGULAR;
        } else if (hasRedSandStorms(biome)) {
            return SandstormType.RED;
        } else {
            return SandstormType.NONE;
        }
    }

    public static SandstormType getCurrentSandStorm(class_1937 world, class_2338 pos) {
        return getCurrentSandStorm(world, pos, true);
    }

    public static boolean isSandStorming(class_1937 world, class_2338 pos) {
        return getCurrentSandStorm(world, pos, false) != SandstormType.NONE;
    }

    /**
     * Determines if the given biome can have sandstorms. Does not determine if it is currently sand storming - just
     * that the possibility of sand storms exists in that biome.
     *
     * @param biome
     * @return
     */
    public static boolean hasSandStorms(class_6880<class_1959> biome) {
        return !biome.comp_349().method_48163() && biome.method_40220(SBiomeTags.HAS_SAND_STORMS);
    }


    public static boolean hasRegularSandStorms(class_6880<class_1959> biome) {
        return !biome.comp_349().method_48163() && biome.method_40220(SBiomeTags.HAS_REGULAR_SAND_STORMS);
    }

    public static boolean hasRedSandStorms(class_6880<class_1959> biome) {
        return !biome.comp_349().method_48163() && biome.method_40220(SBiomeTags.HAS_RED_SAND_STORMS);
    }

    private Sandstorms() {

    }
}
