package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.server.network.TemperatureSoundEventPacket;
import com.github.thedeathlycow.thermoo.api.ThermooCodecs;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5863;
import net.minecraft.class_7923;

public class SoundTemperatureEffect extends TemperatureEffect<SoundTemperatureEffect.Config> {

    /**
     * @param configCodec Codec for the config type
     */
    public SoundTemperatureEffect(Codec<Config> configCodec) {
        super(configCodec);
    }

    @Override
    public void apply(class_1309 victim, class_3218 serverWorld, Config config) {
        if (config.onlyPlayToSource) {
            this.playSoundToSource(victim, serverWorld, config);
        } else {
            victim.method_5783(
                    config.sound,
                    config.volume.method_33920(serverWorld.field_9229),
                    config.pitch.method_33920(serverWorld.field_9229)
            );
        }
    }

    @Override
    public boolean shouldApply(class_1309 victim, Config config) {
        return victim.field_6012 % config.interval == 0;
    }

    private void playSoundToSource(class_1309 victim, class_3218 world, Config config) {
        if (victim instanceof class_3222 serverPlayer) {
            var random = victim.method_59922();

            ServerPlayNetworking.send(
                    serverPlayer,
                    new TemperatureSoundEventPacket(
                            config.sound,
                            config.category,
                            config.volume.method_33920(random),
                            config.pitch.method_33920(random),
                            world.method_8412()
                    )
            );
        }
    }

    public record Config(
            class_3414 sound,
            class_3419 category,
            boolean onlyPlayToSource,
            class_5863 volume,
            class_5863 pitch,
            int interval
    ) {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                        class_7923.field_41172.method_39673()
                                .fieldOf("sound")
                                .forGetter(Config::sound),
                        ThermooCodecs.createEnumCodec(class_3419.class)
                                .fieldOf("category")
                                .orElse(class_3419.field_15250)
                                .forGetter(Config::category),
                        Codec.BOOL
                                .fieldOf("only_play_to_source")
                                .orElse(false)
                                .forGetter(Config::onlyPlayToSource),
                        class_5863.field_29007
                                .fieldOf("volume")
                                .forGetter(Config::volume),
                        class_5863.field_29007
                                .fieldOf("pitch")
                                .forGetter(Config::pitch),
                        Codec.INT
                                .fieldOf("interval")
                                .forGetter(Config::interval)
                ).apply(instance, Config::new)
        );
    }

}
