/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.scorchful.config;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.section.ClientConfig;
import com.github.thedeathlycow.scorchful.config.section.CombatConfig;
import com.github.thedeathlycow.scorchful.config.section.DehydrationConfig;
import com.github.thedeathlycow.scorchful.config.section.HeatingConfig;
import com.github.thedeathlycow.scorchful.config.section.SchemaConfig;
import com.github.thedeathlycow.scorchful.config.section.ThirstConfig;
import com.github.thedeathlycow.scorchful.config.section.WeatherConfig;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

class Updater {
    static void run() {
        Path clothConfigPath = FabricLoader.getInstance().getConfigDir().resolve("scorchful.json");
        if (Files.exists(clothConfigPath, new LinkOption[0])) {
            try {
                Updater.updateToYACL(clothConfigPath);
                Scorchful.LOGGER.info("Scorchful config files successfully updated to YACL format");
            }
            catch (Exception e) {
                Scorchful.LOGGER.error("Unable to update config file to YACL", (Throwable)e);
            }
        }
    }

    private static void updateToYACL(Path oldConfigPath) throws IOException {
        Scorchful.LOGGER.info("Attempting to update Scorchful config files to YACL");
        String content = Files.readString(oldConfigPath);
        JsonObject root = JsonParser.parseString((String)content).getAsJsonObject();
        JsonObject clientConfig = root.remove("clientConfig").getAsJsonObject();
        JsonObject heatingConfig = root.remove("heatingConfig").getAsJsonObject();
        JsonObject combatConfig = root.remove("combatConfig").getAsJsonObject();
        JsonObject weatherConfig = root.remove("weatherConfig").getAsJsonObject();
        JsonObject thirstConfig = root.remove("thirstConfig").getAsJsonObject();
        JsonObject dehydrationConfig = root.getAsJsonObject("integrationConfig").remove("dehydrationConfig").getAsJsonObject();
        boolean writeSchemaFile = Updater.copyOldConfigObject(clientConfig, ClientConfig.PATH);
        writeSchemaFile &= Updater.copyOldConfigObject(combatConfig, CombatConfig.PATH);
        writeSchemaFile &= Updater.copyOldConfigObject(heatingConfig, HeatingConfig.PATH);
        writeSchemaFile &= Updater.copyOldConfigObject(weatherConfig, WeatherConfig.PATH);
        writeSchemaFile &= Updater.copyOldConfigObject(thirstConfig, ThirstConfig.PATH);
        if (writeSchemaFile &= Updater.copyOldConfigObject(dehydrationConfig, DehydrationConfig.PATH)) {
            JsonObject json = new JsonObject();
            json.addProperty("schemaVersion", (Number)1);
            Files.writeString(SchemaConfig.PATH, (CharSequence)json.toString(), StandardOpenOption.CREATE);
        }
        Files.delete(oldConfigPath);
    }

    private static boolean copyOldConfigObject(JsonObject json, Path dest) throws IOException {
        if (!Files.exists(dest, new LinkOption[0])) {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.writeString(dest, (CharSequence)json.toString(), StandardOpenOption.CREATE);
            return true;
        }
        Scorchful.LOGGER.warn("Config file {} already exists, skipping upgrade", (Object)dest);
        return false;
    }

    private Updater() {
    }
}

