package com.github.thedeathlycow.scorchful.event;

import com.github.thedeathlycow.scorchful.temperature.heatvision.HeatVision;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

@FunctionalInterface
public interface HeatVisionActivation {

    /**
     * Fired when a player approaches a heat vision.
     */
    Event<HeatVisionActivation> EVENT = EventFactory.createArrayBacked(
            HeatVisionActivation.class,
            listeners -> (vision, world, pos, cause) -> {
                for (var listener : listeners) {
                    listener.onActivated(vision, world, pos, cause);
                }
            }
    );

    void onActivated(HeatVision vision, class_3218 world, class_2338 pos, class_1657 cause);
}
