package com.github.thedeathlycow.scorchful.item;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.ItemConfig;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.scorchful.registry.SItems;
import net.fabricmc.fabric.api.item.v1.DefaultItemComponentEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class TurtleArmorEffects {
    public static void update(class_1657 player) {
        if (player.method_5777(class_3486.field_15517)) {
            return;
        }

        ItemConfig config = ScorchfulConfig.getItemConfig();
        if (!config.isTurtleArmorEffectsEnabled()) {
            return;
        }

        double lungCapacitySeconds = player.method_45325(SEntityAttributes.LUNG_CAPACITY) * config.getTurtleArmorLungCapacityMultiplier();
        int lungCapacityTicks = class_3532.method_15384(lungCapacitySeconds * 20);

        if (lungCapacityTicks > 0) {
            player.method_6092(
                    new class_1293(
                            class_1294.field_5923,
                            lungCapacityTicks, 0,
                            false, false, true
                    )
            );
        }
    }

    public static void initialize() {
        DefaultItemComponentEvents.MODIFY.register(context -> {
            context.modify(
                    class_1802.field_8090,
                    builder -> addLungCapacity(builder, class_9274.field_49223)
            );
            context.modify(
                    SItems.TURTLE_CHESTPLATE,
                    builder -> addLungCapacity(builder, class_9274.field_49222)
            );
            context.modify(
                    SItems.TURTLE_LEGGINGS,
                    builder -> addLungCapacity(builder, class_9274.field_49221)
            );
            context.modify(
                    SItems.TURTLE_BOOTS,
                    builder -> addLungCapacity(builder, class_9274.field_49220)
            );
        });
    }

    private static void addLungCapacity(
            class_9323.class_9324 builder,
            class_9274 slot
    ) {
        class_9285 attributes = builder.getOrDefault(
                class_9334.field_49636,
                class_9285.field_49326
        );

        attributes = attributes
                .method_57484(
                        SEntityAttributes.LUNG_CAPACITY,
                        new class_1322(
                                Scorchful.id("lung_capacity/").method_48331(slot.method_15434()),
                                10.0,
                                class_1322.class_1323.field_6328
                        ),
                        slot
                );

        builder.method_57840(class_9334.field_49636, attributes);
    }

    private TurtleArmorEffects() {

    }
}
