package com.github.thedeathlycow.scorchful.mixin.client;

import com.github.thedeathlycow.scorchful.client.ShaderEffectRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import net.minecraft.class_9920;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_757.class)
public class GameRendererMixin {
    @Shadow @Final private class_310 client;

    @Shadow @Final private class_9920 pool;

    @Inject(
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/render/WorldRenderer;drawEntityOutlinesFramebuffer()V",
                    shift = At.Shift.AFTER
            ),
            method = "render"
    )
    private void hookShaderRender(class_9779 tickCounter, boolean tick, CallbackInfo ci) {
        ShaderEffectRenderCallback.EVENT.invoker().renderShaderEffects(
                this.client,
                this.pool,
                tickCounter
        );
    }

}