package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.registry.tag.SDamageTypeTags;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_7923;

public final class SEntityTypes {
    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful entity types");

        ServerLivingEntityEvents.AFTER_DAMAGE.register(
                (entity, source, baseDamageTaken, damageTaken, blocked) -> {
                    if (!blocked && source.method_48789(SDamageTypeTags.FIREBALL)) {
                        entity.thermoo$addTemperature(
                                ScorchfulConfig.getTemperatureConfig().getFireballHeat(),
                                HeatingModes.ACTIVE
                        );
                    }
                }
        );
    }

    private static void register(String id, class_1299<?> type) {
        class_2378.method_10230(class_7923.field_41177, Scorchful.id(id), type);
    }

    private SEntityTypes() {

    }
}
