package com.github.thedeathlycow.scorchful.registry;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.registry.tag.SBiomeTags;
import com.github.thedeathlycow.scorchful.temperature.heatvision.ApproachEffects;
import com.github.thedeathlycow.scorchful.temperature.heatvision.BlockDisplayHeatVision;
import com.github.thedeathlycow.scorchful.temperature.heatvision.EntityHeatVision;
import com.github.thedeathlycow.scorchful.temperature.heatvision.HeatVision;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2378;

public final class SHeatVisions {

    public static final HeatVision HUSK = register(
            "husk",
            new EntityHeatVision<>(
                    SBiomeTags.HEAT_VISION_HUSK,
                    6,
                    class_1299.field_6071
            )
    );
    public static final HeatVision BOAT = register(
            "boat",
            new EntityHeatVision<>(
                    SBiomeTags.HEAT_VISION_BOAT,
                    6,
                    class_1299.field_54410
            )
    );
    public static final HeatVision POPPY = register(
            "poppy",
            new BlockDisplayHeatVision(
                    SBiomeTags.HEAT_VISION_POPPY,
                    3,
                    class_2246.field_10449::method_9564
            )
    );
    public static final HeatVision BLUE_ORCHID = register(
            "blue_orchid",
            new BlockDisplayHeatVision(
                    SBiomeTags.HEAT_VISION_BLUE_ORCHID,
                    3,
                    class_2246.field_10086::method_9564
            )
    );
    public static final HeatVision SALMON = register(
            "salmon",
            new EntityHeatVision<>(
                    SBiomeTags.HEAT_VISION_SALMON,
                    2,
                    class_1299.field_6073
            )
    );
    public static final HeatVision COD = register(
            "cod",
            new EntityHeatVision<>(
                    SBiomeTags.HEAT_VISION_COD,
                    2,
                    class_1299.field_6070
            )
    );
    public static final HeatVision SQUID = register(
            "squid",
            new EntityHeatVision<>(
                    SBiomeTags.HEAT_VISION_SQUID,
                    2,
                    class_1299.field_6114
            )
    );


    public static void initialize() {
        Scorchful.LOGGER.debug("Initialized Scorchful heat visions");
        ApproachEffects.initialize();
    }

    private static HeatVision register(String id, HeatVision vision) {
        return class_2378.method_10230(SRegistries.HEAT_VISION, Scorchful.id(id), vision);
    }

    private SHeatVisions() {

    }
}
