package com.github.thedeathlycow.scorchful.temperature;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.components.RehydrationComponent;
import com.github.thedeathlycow.scorchful.components.ScorchfulComponents;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.config.section.EntityConfig;
import com.github.thedeathlycow.scorchful.mixin.accessor.EntityAccessor;
import com.github.thedeathlycow.scorchful.registry.SEntityAttributes;
import com.github.thedeathlycow.scorchful.registry.tag.SItemTags;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentTickContext;
import com.github.thedeathlycow.thermoo.api.temperature.event.LivingEntitySoakingTickEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3486;

public final class SoakingEffects {
    public static final class_2960 REHYDRATION_TICK_PHASE = Scorchful.id("rehydration_tick");

    public static void initialize() {
        LivingEntitySoakingTickEvents.GET_SOAKING_CHANGE.register(SoakingEffects::getSoakingChange);

        // place in an earlier phase in case of cancellation
        LivingEntitySoakingTickEvents.ALLOW_SOAKING_CHANGE.addPhaseOrdering(REHYDRATION_TICK_PHASE, Event.DEFAULT_PHASE);
        LivingEntitySoakingTickEvents.ALLOW_SOAKING_CHANGE.register(
                REHYDRATION_TICK_PHASE,
                (context, soakingChange) -> {
                    SoakingEffects.tickRehydration(context, soakingChange);
                    return TriState.DEFAULT;
                }
        );
    }

    private static int getSoakingChange(EnvironmentTickContext<? extends class_1309> context) {
        if (context.affected().method_7325()) {
            return 0;
        }

        class_1309 entity = context.affected();

        // fully soak in water
        if (entity.method_5777(class_3486.field_15517)) {
            return entity.thermoo$getMaxWetTicks();
        }

        EntityConfig config = ScorchfulConfig.getEntityConfig();
        int total = 0;

        total += getTouchingWaterChange(entity, config);
        total -= getOnFireChange(entity, config);

        return total;
    }

    private static int getTouchingWaterChange(class_1309 entity, EntityConfig config) {
        // add wetness when touching, but not submerged in, water or rain
        if (isTouchingWater(entity) || entity.method_55667().method_27852(class_2246.field_27097)) {
            return config.getTouchingWaterWetnessIncrease();
        }

        return 0;
    }

    private static int getOnFireChange(class_1309 entity, EntityConfig config) {
        return entity.method_5809()
                ? config.getOnFireDryDate()
                : 0;
    }

    private static void tickRehydration(EnvironmentTickContext<? extends class_1309> context, int wetChange) {
        if (context.affected() instanceof class_1657 player) {
            double rehydrationEfficiency = player.method_45325(SEntityAttributes.REHYDRATION_EFFICIENCY);
            RehydrationComponent component = ScorchfulComponents.REHYDRATION.get(player);
            component.tickRehydration(rehydrationEfficiency, wetChange);
        }
    }

    private static boolean isTouchingWater(class_1309 entity) {
        if (entity.method_5799()) {
            return true;
        }

        return ((EntityAccessor) entity).scorchful$invokeIsBeingRainedOn()
                && !entity.method_24520(stack -> stack.method_31573(SItemTags.BLOCKS_RAIN_WHEN_HOLDING));
    }

    private SoakingEffects() {

    }
}