package com.github.thedeathlycow.scorchful.temperature.heatvision;

import com.github.thedeathlycow.scorchful.Scorchful;
import com.github.thedeathlycow.scorchful.config.ScorchfulConfig;
import com.github.thedeathlycow.scorchful.registry.SStatusEffects;
import com.github.thedeathlycow.scorchful.util.SMth;
import org.joml.Vector2i;

import java.util.OptionalInt;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class VisionSpawner {

    private static final VisionGenerator generator = new VisionGenerator();

    public static void tick(class_1657 player) {

        if (!ScorchfulConfig.getEntityConfig().enableDesertVisions()) {
            return;
        }

        class_1937 world = player.method_73183();

        if (world.method_8608() || !player.method_6059(SStatusEffects.HEAT_STROKE)) {
            return;
        }

        int sunLight = world.method_8314(class_1944.field_9284, player.method_24515()) - world.method_8594();
        if (sunLight < 14) {
            return;
        }

        if (player.field_6012 % 20 == 0 && player.method_59922().method_43048(10) == 0) {
            spawnDesertVision((class_3218) world, player);
        }
    }

    private static void spawnDesertVision(class_3218 serverWorld, class_1657 cause) {
        class_2338 pos = chooseVisionPos(serverWorld, cause.method_24515(), cause.method_59922());
        if (pos == null) {
            return;
        }
        var controller = generator.chooseVision(serverWorld, pos);
        if (controller != null) {
            controller.spawn(cause, serverWorld, pos);
            Scorchful.LOGGER.debug("Spawned a desert vision at " + pos);
        }
    }

    private static class_2338 chooseVisionPos(class_3218 serverWorld, class_2338 origin, class_5819 random) {
        Vector2i xz = generateXZ(random, origin.method_10263(), origin.method_10260(), 32, 4);
        OptionalInt y = generateY(serverWorld, origin, xz.x, xz.y);
        if (y.isEmpty()) {
            return null;
        }
        return new class_2338(xz.x, y.getAsInt(), xz.y);
    }

    /**
     * Generates points in a 2D doughnut distribution around the origin
     * <p>
     * Based on approach 1 from <a href="https://codegolf.stackexchange.com/questions/243774/random-point-from-a-2d-donut-distribution">this code golf challenge</a>
     *
     * @param random  random source
     * @param xOrigin x origin
     * @param yOrigin y origin
     * @param radius  radius of the doughnut
     * @param spread  how far from the radius points should spread (normally distributed)
     * @return returns a new vector with point randomly sampled as described
     */
    private static Vector2i generateXZ(class_5819 random, int xOrigin, int yOrigin, double radius, double spread) {
        double a = class_3532.method_15366(random, 0, Math.PI * 2);
        double b = SMth.nextGaussian(random, radius, spread);
        return new Vector2i(
                xOrigin + class_3532.method_15357(b * Math.cos(a)),
                yOrigin + class_3532.method_15357(b * Math.sin(a))
        );
    }

    private static OptionalInt generateY(class_3218 serverWorld, class_2338 playerOrigin, int visionX, int visionZ) {
        return OptionalInt.of(serverWorld.method_8624(class_2902.class_2903.field_13197, visionX, visionZ));
    }

    private VisionSpawner() {
    }
}
